/*******************************************************************************
 *	TmsC.h	Produced by Bidl
 *******************************************************************************
 */

#ifndef TMSC_H
#define TMSC_H 1

#include <stdlib.h>
#include <stdint.h>
#include <Boap.h>
#include <BString.h>
#include <BList.h>
#include <BArray.h>
#include <TmsD.h>


//*****************************************************************************/
//	Base objects for BEAM TMS System
//			T.Barnaby,	BEAM Ltd,	2006-12-07
//*****************************************************************************/
//
namespace Tms {
	const BUInt32 apiVersion = 0;

	/// This class stores a Physical Pick-Up channel id
	/// This class stores the status of an individual Pick-Up
	/// This class describes the configuration of the TMS
	/// This class defines the data to be acquired and/or fetched
	/// This is the definition of a single data value
	/// This class stores the raw data
	/// This class defines the Pick-Up state table
	/// This class defines the parameters for a PS processing cycle
	// This class is used to return the list of CycleParm's
	/// This class defines the parameters for a test data capture
	// Special PUPE configuration for test purposes
	/// This interface provides functions to control, test and get statistics from an individual pick-up
	class PuControl : public BoapClientObject {
	public:
			PuControl(BString name = "");
		BError getVersion(BString& version);	///< Gets the software version
		BError init();	///< InitialisesthesystemincludingloadingallofthePUPEenginesfirmware.Thecallwillreturnanerrorobjectindicatingsuccessoranerrorconditionasappropriate.
		BError setProcessPriority(UInt32 priority);	///< Sets the priority of the process servicing this service
		BError configure(ConfigInfo configInfo);	///< Configure the system for use. This includes mapping the individual physical PickUp channels to logical pickup channels.
		BError setControlInfo(CycleParam params);	///< Sets the control information for the cycle type given and subsequent cycles. The parameters for the processing cycle are passed, this includes the Phase and State table information. The call will return an error object indicating success or an error
		BError setNextCycle(UInt32 cycleNumber, BString cycleType);	///< Sets the cycle number and type for the next processing cycle. The call will return an error object indicating success or an error condition as appropriate. This should be called at least 10ms before the next CYCLE_START event.
		BError test(BList<BError>& errors);	///< Performsabasictestofthesystemreturningalistoferrors.Thecallwillreturnanerrorobjectindicatingsuccessoranerrorconditionasappropriate.
		BError getStatus(BList<NameValue>& statusList);	///< Returnsthecurrentstatusofthesystem.ThisinformationincludesthenumberofPickUp\u2019spresentandtheirindividualstatus.
		BError getStatistics(BList<NameValue>& statsList);	///< Returnsalistofthestatisticvaluesasname/valuepairs.Thecallwillreturnanerrorobjectindicatingsuccessoranerrorconditionasappropriate.
		// Test functions
		BError setTestMode(PuChannel puChannel, UInt32 testOutput, UInt32 timingDisableMask);	///< The signal source for the digital test output connector. 0: None, 1: FrefLocal. The timingDisableMask bit mask defines which of the timing inputs should be disabled. If a timing input is disabled it can be still operated by software command.
		BError setTimingSignals(PuChannel puChannel, UInt32 timingSignals);	///< This function sets the given timing signals to the values as defined in the timingSignals bit array.
		BError captureTestData(PuChannel puChannel, TestCaptureInfo captureInfo, BArray<UInt64>& data);	///< This function will capture test data
		BError setTestData(PuChannel puChannel, Int32 on, BArray<UInt32> data);	///< This function will set a PU channel to sample data from memory rather than the ADC's
		BError setPupeConfig(PuChannel puPhysChannel, PupeConfig pupeConfig);	///< Sets special PUPE configuration for test purposes
		BError getPupeConfig(PuChannel puPhysChannel, PupeConfig& pupeConfig);	///< Gets special PUPE configuration for test purposes
	private:
	};
	//
	/// This interface provides functions to configure and capture data from individual pick-up
	class PuProcess : public BoapClientObject {
	public:
			PuProcess(BString name = "");
		BError getVersion(BString& version);	///< Gets the software version
		BError getStatus(PuChannel puChannel, PuStatus& puStatus);
		BError getData(PuChannel puChannel, DataInfo dataInfo, Data& data);	///< This function returns a set of data from the data present in the data cache or directly from the Pick-Up processing engines. The  DataInfo object describes the data required. The call will return the required data along with an error object indicating success or an error condition as appropriate. The call will block until data is ready.
		BError addEventServer(BString name);	///< Adds an event server
		BError requestData(PuChannel puChannel, DataInfo dataInfo);	///< This adds a request for some data. The DataInfo object defines the data required. This request can be made at any time. If the data is present in cache the data will be available immediately, if not the system will await the data from a subsequent processing cycle. When the data is available a "data" event will be sent to the client. Not that it is not necessary to use requestData. The client can call getData() directly although this call will block until the data is actually ready.
	private:
	};
	//
	/// This interface provides functions to control, test and get statistics from the TMS as a whole
	class TmsControl : public BoapClientObject {
	public:
			TmsControl(BString name = "");
		BError getVersion(BString& version);	///< Gets the software version
		BError setProcessPriority(UInt32 priority);	///< Sets the priority of the process servicing this service
		BError init();	///< Initialises the system including resetting all of the PUPE engines firmware. The call will return an error object indicating success or an error condition as appropriate.
		BError configure(ConfigInfo configInfo);	///< Configure the system for use. This includes mapping the individual physical PickUp channels to logical pickup channels.
		BError getConfiguration(ConfigInfo& configInfo);	///< Get the current configuration
		BError setControlInfo(CycleParam params);	///< Sets the control information for the cycle type given. The parameters for the processing cycle are passed, this includes the Phase and State table information. The call will return an error object indicating success or an error
		BError getControlInfo(BString cycleType, UInt32 puChannel, CycleParam& params);	///< Gets the control information for the cycle type and puChannel number given. The call will return an error object indicating success or an error
		BError delControlInfo(BString cycleType, UInt32 puChannel);	///< Deletes the control information for the cycle type and puChannel number given. The call will return an error object indicating success or an error
		BError getControlList(BList<CycleParamItem>& itemList);	///< Gets the list of Cycle Parameters present in the system
		BError setNextCycle(UInt32 cycleNumber, BString cycleType);	///< Sets the cycle number and type for the next processing cycle. The call will return an error object indicating success or an error condition as appropriate. This should be called at least 10ms before the next CYCLE_START event.
		BError test(BList<BError>& errors);	///< Performsabasictestofthesystemreturningalistoferrors.Thecallwillreturnanerrorobjectindicatingsuccessoranerrorconditionasappropriate.
		BError getStatus(BList<NameValue>& statusList);	///< Returnsthecurrentstatusofthesystem.ThisinformationincludesthenumberofPickUp\u2019spresentandtheirindividualstatus.
		BError getStatistics(BList<NameValue>& statsList);	///< Returnsalistofthestatisticvaluesasname/valuepairs.Thecallwillreturnanerrorobjectindicatingsuccessoranerrorconditionasappropriate.
		BError getPuChannel(UInt32 puChannel, PuChannel& puPhysChannel);	///< Returns the physical module/Pupe/Channel number given a logical PickUp id. This can be used so that the individual PickUps test functions can be accessed etc.
		// Test functions
		BError setTestMode(PuChannel puPhysChannel, UInt32 testOutput, UInt32 timingDisableMask);	///< The signal source for the digital test output connector. 0: None, 1: FrefLocal. The timingDisableMask bit mask defines which of the timing inputs should be disabled. If a timing input is disabled it can be still operated by software command.
		BError setTimingSignals(PuChannel puPhysChannel, UInt32 timingSignals);	///< This function sets the given timing signals to the values as defined in the timingSignals bit array.
		BError captureTestData(PuChannel puPhysChannel, TestCaptureInfo captureInfo, BArray<UInt64>& data);	///< This function will capture test data
		BError setTestData(PuChannel puPhysChannel, Int32 on, BArray<UInt32> data);	///< This function will set a PU channel to sample data from memory rather than the ADC's
		BError setPupeConfig(PuChannel puPhysChannel, PupeConfig pupeConfig);	///< Sets special PUPE configuration for test purposes
		BError getPupeConfig(PuChannel puPhysChannel, PupeConfig& pupeConfig);	///< Gets special PUPE configuration for test purposes
		// Internal functions
		BError puServerStarted(UInt32 number);	///< A TmsPuServer has started
	private:
	};
	//
	/// This interface provides functions to capture data from the TMS as a whole
	class TmsProcess : public BoapClientObject {
	public:
			TmsProcess(BString name = "");
		BError getVersion(BString& version);	///< Gets the software version
		BError getCycleInfo(UInt32& cycleNumber, BString& cycleType);	///< Gets the current cycle number and type.
		BError getData(DataInfo dataInfo, Data& data);	///< This function returns a set of data from the data present in the data cache or directly from the Pick-Up processing engines. The  DataInfo object describes the data required. The call will return the required data along with an error object indicating success or an error condition as appropriate. The call will block until data is ready.
		BError addEventServer(BString name);	///< This call adds an event server to call on events such as the "dataEvent" generated by the requestData(0 call as well as error events. The Client will use this to notify the TmsServer of its local TmsEvent object.
		BError requestData(DataInfo dataInfo);	///< This adds a request for some data. The DataInfo object defines the data required. This request can be made at any time. If the data is present in cache the data will be available immediately, if not the system will await the data from a subsequent processing cycle. When the data is available a "data" event will be sent to the client. Not that it is not necessary to use requestData. The client can call getData() directly although this call will block until the data is actually ready.
	private:
	};
	//
	/// This interface provides functions for events to be sent to clients from the TMS as a whole
	class TmsEvent : public BoapClientObject {
	public:
			TmsEvent(BString name = "");
		BError errorEvent(UInt32 cycleNumber, BError error);	///< This event function gets called on a system error. The errorEvent object contains and error number and string describing the error. The getStatus() call can be used to fetch further information.
		BError cycleStartEvent(UInt32 cycleNumber);	///< This event function gets called on the CYCLE_START event with the cycle number about to be processed
		BError cycleStopEvent(UInt32 cycleNumber);	///< This event function gets called on the CYCLE_END event with the cycle number completed
		BError dataEvent(DataInfo dataInfo);	///< This event function gets called when some requested data becomes available. The DataInfo object contains information on the data. The getData() call can be used to fetch the actual data.
	private:
	};
	//
}
#endif
