/*******************************************************************************
 *	BTable.h	Simple table of data with CSV output
 *			T.Barnaby,	BEAM Ltd,	2009-02-10
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BTable_H
#define BTable_H

#include <BArray.h>
#include <BString.h>

class BTable {
public:
				BTable();
				~BTable();
	
	void			clear();
	void			setTitle(BArray<BString> title);
	void			addRow(BArray<BString>  data);
	
	void			print();

private:
	void			calculateWidths();
	void			printLine(BArray<BString> line, int comment = 0);
	
	BArray<BString> 	otitle;
	BList<BArray<BString> >	odata;
	BArray<int>		ocolumnWidths;
};

#endif
