/*******************************************************************************
 *	BTable.cc	Simple table of data with CSV output
 *			T.Barnaby,	BEAM Ltd,	2009-02-10
 *******************************************************************************
 */

#include <BTable.h>

BTable::BTable(){
}

BTable::~BTable(){
}

void BTable::clear(){
	odata.clear();
}

void BTable::setTitle(BArray<BString>  title){
	otitle = title;
}

void BTable::addRow(BArray<BString>  data){
	odata.append(data);
}

void BTable::printLine(BArray<BString> line, int comment){
	BUInt	c;
	BString	s;

	if(line.size()){
		for(c = 0; c < line.size(); c++){
			if((c == 0) && comment)
				s = BString("#") + line[c];
			else
				s = line[c];
			if(c < (line.size() - 1))
				s = s + ",";
			if(c != (line.size() - 1))
				s = s.pad(ocolumnWidths[c] + 2);
			fputs(s, stdout);
		}
		fputs("\n", stdout);
	}
}

void BTable::print(){
	BIter	i;

	calculateWidths();

	printLine(otitle, 1);

	for(odata.start(i); !odata.isEnd(i); odata.next(i))
		printLine(odata[i]);
}

void BTable::calculateWidths(){
	BUInt	c;
	BIter	i;
	
	ocolumnWidths.resize(otitle.size());
	for(c = 0; c < otitle.size(); c++){
		if(c == 0)
			ocolumnWidths[c] = otitle[c].len() + 1;
		else
			ocolumnWidths[c] = otitle[c].len();
	}
	
	for(odata.start(i); !odata.isEnd(i); odata.next(i)){
		if(ocolumnWidths.size() < odata[i].size())
			ocolumnWidths.resize(odata[i].size());

		for(c = 0; c < ocolumnWidths.size(); c++){
			if(odata[i][c].len() > ocolumnWidths[c])
				ocolumnWidths[c] = odata[i][c].len();
		}
	}
}
