/*******************************************************************************
 *	BStringLocked.h		Threaded BString Handling
 *				T.Barnaby,	BEAM Ltd, 2008-06-17
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BStringLocked_H
#define BStringLocked_H	1

#include	<BString.h>
#include	<BMutex.h>

class BStringMutex : public BMutex {
public:
			BStringMutex(): BMutex(BMutex::Recursive){}
};

class BStringLocked {
public:
			BStringLocked(){}
			BStringLocked(const BStringLocked& s) : ostr(s.ostr){}
			BStringLocked(const BString& s) : ostr(s){}

	int		len() const	{ BMutexLock l(olock); return ostr.len(); }		///< Length of string

public:
			operator BString() const { BMutexLock l(olock); return ostr; }

	BStringLocked 	operator+(const BStringLocked& s) const { BMutexLock l(olock); BMutexLock l1(s.olock); ostr.append(s.ostr); return *this; }
	BStringLocked& 	operator=(const BStringLocked& s) { BMutexLock l(olock); BMutexLock l1(s.olock); ostr = s.ostr; return *this; }

private:
	mutable BStringMutex		olock;
	BString				ostr;
};

#endif
