/*******************************************************************************
 *	BSpi.h	BSpi class
 *	T.Barnaby,	Beam Ltd,	2012-11-12
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BSpi_h
#define BSpi_h

#include <BTypes.h>
#include <BError.h>

/// BSpi class
class BSpi {
public:
	enum Mode	{ Mode0 = 0, Mode1 = 1, Mode2 = 2, Mode3 = 3 };

			BSpi();
	BError		init(BString devName, BUInt speed = 1000000, Mode mode = Mode1, Bool csActive = 0);
	
	BError		transact(BUInt8 dev, void* txBuf, int txLen, int pad, void* rxBuf, int rxLen);

private:
	BString		odevName;
	int		odev;
};

#endif
