/*******************************************************************************
 *	BObjStringFormat.h		Beam Object to/from strings
 *			T.Barnaby,	BEAM Ltd,	2016-09-27
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 *
 * Convert data objects to and from various string formats.
 */
#ifndef BObjStringFormat_H
#define BObjStringFormat_H	1

#include	<BObj.h>
#include	<BString.h>
#include	<BTime.h>

BString toBString(BString name, Bool value);
BString toBString(BString name, BInt8 value);
BString toBString(BString name, BUInt8 value);
BString toBString(BString name, BInt16 value);
BString toBString(BString name, BUInt16 value);
BString toBString(BString name, BInt32 value);
BString toBString(BString name, BUInt32 value);
BString toBString(BString name, BFloat32 value);
BString toBString(BString name, BFloat64 value);
BString toBString(BString name, BChar value);
BString toBString(BString name, const BChar* value);
BString toBString(BString name, BString value);
BString toBString(BString name, BError value);
BString toBString(BString name, BTime time);

BString toBString(BString name, const BObjMember* members, const void* obj, BStringList ignoreFields = BStringList());
BString toBString(BString name, BObj& obj);

BString toBStringJson(BString name, Bool value);
BString toBStringJson(BString name, BInt8 value);
BString toBStringJson(BString name, BUInt8 value);
BString toBStringJson(BString name, BInt16 value);
BString toBStringJson(BString name, BUInt16 value);
BString toBStringJson(BString name, BInt32 value);
BString toBStringJson(BString name, BUInt32 value);
BString toBStringJson(BString name, BFloat32 value);
BString toBStringJson(BString name, BFloat64 value);
BString toBStringJson(BString name, BChar value);
BString toBStringJson(BString name, const BChar* value);
BString toBStringJson(BString name, BString value);
BString toBStringJson(BString name, BError value);
BString toBStringJson(BString name, BTime time);

BString toBStringJson(BString name, const BObjMember* members, const void* obj, BStringList ignoreFields = BStringList());
BString toBStringJson(BString name, BObj& obj);

BError toBDictStringFromJson(BString json, BDictString& ds);

BString base64_encode(void* data, BUInt len);
BError base64_decode(BString strIn, BString& strOut);

#endif
