/*******************************************************************************
 *	BObj.h		Beam Object
 *			T.Barnaby,	BEAM Ltd,	2008-06-04
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BObj_H
#define BObj_H	1

#include	<BTypes.h>
#include	<BDict.h>
#include	<BString.h>
#include	<BError.h>


class BObj {
public:
				BObj();
	virtual			~BObj();

	// member interface
	virtual const char*		getType() const;
	virtual const BObjMember*	getMembers() const;

	// Old member interface
	virtual BError		getMembers(BDictString& members);
	virtual BError		getMember(BString name, BString& value);
	virtual BError		setMembers(BDictString& members);
	virtual BError		setMember(BString name, BString value);
	
				// Debug functions
	virtual void		membersPrint() const;				///< Prints out members
	virtual BString		getDebugString();				///< Returns contents as a debug string
};

#endif
