/*******************************************************************************
 *	BFileData.cpp	BEAM CSV access class
 *			T.Barnaby,	BEAM Ltd,	2012-01-10
 *******************************************************************************
 */
#include	<BFileCsv.h>
#include	<BFileData.h>
#include	<errno.h>

BError	BFileData::open(BString filename){
	BError	err;

	ofilename = filename;
	
	err = read();
	
	if(err == ErrorEndOfFile)
		err.set(ErrorOk, "");
	
	return err;
}

BError	BFileData::read(){
	BError		err;
	BFileCsv	file;
	BStringList	l;
	
	if(err = file.open(ofilename, "a+")){
		return err;
	}
	
	while(!(err = file.readCsv(l))){
		append(l);
	}
	return err;
}

BError	BFileData::write(){
	BError		err;
	BFileCsv	file;
	BStringList	l;
	BIter		i;
	
	if(err = file.open(ofilename, "w")){
		return err;
	}
	
	for(start(i); !isEnd(i); next(i)){
		file.writeCsv(get(i));
	}

	return err;
}

BError	BFileData::getNextId(int& id){
	BError	err;
	BIter	i;
	
	id = 0;
	
	for(start(i); !isEnd(i); next(i)){
		if(get(i)[0].retInt() > id)
			id = get(i)[0].retInt();
	}
	id++;
	
	return err;
}

BError	BFileData::find(int id, BStringList& csvList){
	BError	err;
	BIter	i;
	
	for(start(i); !isEnd(i); next(i)){
		if(get(i)[0].retInt() == id){
			csvList = get(i);
			return err;
		}
	}
	
	return err.set(ErrorMisc, "Not found");
}

BError	BFileData::write(int id, BStringList& csvList){
	BError	err;
	BIter	i;
	int	found = 0;
	
	if(id == 0){
		getNextId(id);
		csvList[0] = id;
		append(csvList);
	}
	else {
		for(start(i); !isEnd(i); next(i)){
			if(get(i)[0].retInt() == id){
				get(i) = csvList;
				found = 1;
				break;
			}
		}
		if(!found){
			append(csvList);
		}
	}

	return write();
}

#ifdef ZAP
BError	BFileData::del(int id){
	BError	err;
	BIter	i;
	
	for(start(i); !isEnd(i); next(i)){
		if(get(i)[0].retInt() == id){
			BList<BStringList>::del(i);
			break;
		}
	}
	return write();
}
#endif
