/*******************************************************************************
 *	BErrorTime.h	BErrorTime Class
 *			T.Barnaby,	BEAM Ltd,	2010-05-26
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BErrorTime_H
#define BErrorTime_H	1

#include <BString.h>
#include <BTimeStamp.h>

/// Error return class
class BErrorTime {
public:
	enum		Type { None = 0, Error = 1 };							///< Type of error

			BErrorTime(int errNo = None, BTimeStamp errTime = BTimeStamp(), BString errStr = "");	///< Create object

	BErrorTime&	set(int errNo, BTimeStamp errTime = BTimeStamp(), BString errStr = "");		///< Set error number and message
	BErrorTime&	clear();					///< Clear the error
	int		getErrorNo() const;				///< Get The error number
	BTimeStamp	getTime() const;				///< Get time
	BString		getString() const;				///< Get error message

	BErrorTime	copy();						///< Return an independant copy
			operator int() const;				///< Return error number

private:
	int		oerrNo;
	BTimeStamp	oerrTime;
	BString		oerrStr;
};

#endif
