/*******************************************************************************
 *	BComms.h	BComms class
 *	T.Barnaby,	Beam Ltd,	2012-11-12
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BComms_h
#define BComms_h

#include <BTypes.h>
#include <BEvent.h>
#include <BError.h>

class BComms {
public:
	enum Wait		{ WaitNone = 0x00, WaitRead = 0x01, WaitWrite = 0x02, WaitError = 0x04 };

				BComms();
	virtual 		~BComms();

	virtual BError		init();
	virtual BError		setPacketMode(Bool packetMode);					///< Set packet mode
	virtual Bool		packetMode();							///< Device is in packet mode
	virtual BError		setTimeout(BInt timeoutMs);					///< Set communication timeout

	virtual BUInt		writeAvailable();
	virtual BError		write(const void* data, BUInt32 nBytes, BUInt32& nTrans) = 0;

	virtual BUInt		readAvailable();
	virtual BError		read(void* data, BUInt32 num, BUInt32& nTrans) = 0;

	virtual BError		wait(BUInt8 events, BInt timeout = -1, BUInt32 num = 1);
	virtual void		eventQueue(BEventQueue* eventQueue, BInt32 event, BUInt num = 1);

protected:
	Bool			opacketMode;
	BInt32			otimeout;
	BEventQueue*		oeventQueue;
	BInt32			oevent;
	BUInt			oeventNum;
};


#endif
