/*******************************************************************************
 *	BAtomic.h	BAtomic		Atomic variables
 *			T.Barnaby,	BEAM Ltd,	2010-10-07
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BAtomic_H
#define BAtomic_H	1

#include <BTypes.h>

/// BAtomic class
template <class Type> class BAtomic {
public:
			BAtomic(Type value = 0) : ovalue(value){}

	Type		getValue() const {
				return __sync_fetch_and_add(&ovalue, 0);
			}
	Type		add(long value){
				return __sync_add_and_fetch(&ovalue, value);
			}
	Type		operator++(int){
				return __sync_fetch_and_add(&ovalue, 1);
			}	
	Type		operator++(){
				return __sync_add_and_fetch(&ovalue, 1);
			}	
	Type		operator--(int){
				return __sync_fetch_and_add(&ovalue, -1);
			}
	Type		operator--(){
				return __sync_add_and_fetch(&ovalue, -1);
			}
			operator Type() const {
				return getValue();
			}
private:
	mutable Type	ovalue;
};

typedef BAtomic<BInt32>		BAtomicInt32;
typedef BAtomic<BInt64>		BAtomicInt64;
typedef BAtomic<BUInt32>	BAtomicUInt32;
typedef BAtomic<BUInt64>	BAtomicUInt64;

#endif
