/*******************************************************************************
 *	GenDataMc.h	Generate Data output
 *			T.Barnaby,	BEAM Ltd,	12/9/03
 *******************************************************************************
 */
#ifndef GenDataMc_H
#define GenDataMc_H

#include <Gen.h>

class GenDataMc : public Gen {
public:
	enum ObjType	{ ObjTypeStd, ObjTypeBObject, ObjTypeBObj };

			GenDataMc();
			~GenDataMc();
	BError		produce(Node* n, BString fileName);
private:
	BError		produceHeaderInt();
	BError		produceTrailerInt();
	BError		produceHeaderImp();
	BError		produceTrailerImp();
	void		produceInt(Node* n);
	void		produceImp(Node* n);

	BString		ofileName;
	FileIndent	ofileInt;
	FileIndent	ofileImp;
	BString		omodule;
	int		otypeDomain;
	int		otypeNum;
	ObjType		oobjType;
	BString		opostNamespace;
};

#endif
