/*******************************************************************************
 *	GenBoapPython.cc	Boap output
 *			T.Barnaby,	BEAM Ltd,	2/5/03
 *******************************************************************************
 */
#define	DEBUG	1

#define	DODATA		0

#include <stdio.h>
#include <stdarg.h>
#include <strings.h>
#include <GenBoapPython.h>
#include <bidl.h>

BString GenBoapPython::getTypeName(Node* n, int data){
	BString	typeName;
	
	if(n->nodeType() == Node::TTYPELIST){
		return BString("BList");
	}
	else if(n->nodeType() == Node::TTYPEARRAY){
		return BString("BList");
	}
	else if(n->nodeType() == Node::TTYPEDICT){
		return BString("BList");
	}
	else {
		typeName = n->name();
		if(typeName == "Int32")		return "BInt32";
		else if(typeName == "UInt32")	return "BUInt32";
		else if(typeName == "Int16")	return "BInt16";
		else if(typeName == "UInt16")	return "BUInt16";
		else if(typeName == "Int8")	return "BInt8";
		else if(typeName == "UInt8")	return "BUInt8";
		else if(typeName == "Int64")	return "BInt64";
		else if(typeName == "UInt64")	return "BUInt64";
		else if(typeName == "Float32")	return "BFloat32";
		else if(typeName == "Float64")	return "BFloat64";
		else if(typeName == "Bool")	return "BInt32";
		else if(typeName == "String")	return "BString";
		else if(typeName == "Error")	return "BError";
		else if(typeName == "TimeStamp")return "BTimeStamp";
		else return typeName;
	}
}


BError GenBoapPython::produceHeaderPython(){
	BError	err;

	ofilePython.printf("#############################################################################\n");
	ofilePython.printf("#\t%s\tProduced by Bidl\n", (ofileName + ".py").retStr());
	ofilePython.printf("#############################################################################\n");
	ofilePython.printf("#\n");
	ofilePython.printf("from Beam import *\n");
	ofilePython.printf("\n\n");
	return err;
}

void GenBoapPython::produceImpPython(Node* n){
	BString		s;
	BString		t;
	BIter		i;
	BList<Node*>*	nl;
	BString		typeName;
	BString		line;
	
	switch(n->nodeType()){
	case Node::TMODULE:
		omodule = BString("lib") + n->name();

		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceImpPython(n->nodes()[i]);
		}
		break;
	case Node::TLIST:
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceImpPython(n->nodes()[i]);
		}
		break;
	case Node::TSTRUCT:
		if(n->name() == "BObj")
			return;

		typeName = BString("") + n->name();
		ofilePython.writeLine(BString("# ") + typeName + " Object Implementation\n");
		
		if((n->nodes().number() == 2) && n->node(1)){
			ofilePython.writeLine(BString("class ") + typeName + "(" + getTypeName(n->node(1), 1) + "):\n");
		}
		else {
			ofilePython.writeLine(BString("class ") + typeName + ":\n");
		}

		ofilePython.indentMore();
		line = "def __init__(s";
		nl = &n->node(0)->nodes();
		if(nl->number()){
			for(nl->start(i); !nl->isEnd(i); nl->next(i)){
				t = getTypeName(nl->get(i)->node(0), 1);
				s = nl->get(i)->node(1)->name();
				line += BString(", ") + s + " = " + t + "()";
			}
		}
		ofilePython.writeLine(line + "):\n");

		ofilePython.indentMore();
		if((n->nodes().number() == 2) && n->node(1)){
			ofilePython.writeLine(getTypeName(n->node(1), 1) + ".__init__(s);\n");
		}

		nl = &n->node(0)->nodes();
		if(nl->number()){
			for(nl->start(i); !nl->isEnd(i); nl->next(i)){
				t = getTypeName(nl->get(i)->node(0), 1);
				s = nl->get(i)->node(1)->name();
				ofilePython.writeLine(BString("s.") + s + " = " + s + ";\n");
			}
		}
		else {
			ofilePython.writeLine("pass;\n");
		}
		ofilePython.indentLess();
		ofilePython.indentLess();
		ofilePython.writeLine("\n");
		break;
	default:
		break;
	}
}

BError GenBoapPython::produceTrailerPython(){
	BError	err;
	
	return err;
}

void GenBoapPython::pushPopVar(FileIndent& file, int push, BString func, Node* type, BString name){
	BIter		i;
	BList<Node*>*	nl;
	Type*		t;
	Type*		dt;
	BString		s;
	BString		swapType;
	
//	printf("GenBoapPython::pushPopVar: Func(%s) Type(%s) Name(%s)\n", func.retStr(), type->name().retStr(), name.retStr());
	if(t = gtypelist.search(type->name())){
//		printf("DoType: %p Name(%s) Derived(%p)\n", type->name().retStr(), type, t->derived());
		if(dt = t->derived()){
			nl = &dt->node()->nodes();
			for(nl->start(i); !nl->isEnd(i); nl->next(i)){
				pushPopVar(file, push, func, nl->get(i)->node(0), name + "." + nl->get(i)->node(1)->name());
			}
		}
//		printf("Node: %s %s\n", t->node()->name().retStr(), Node::nodeTypeName(t->node()->nodeType()).retStr());
		if(t->node()->name() == "enumeratorList"){
			if(push)
				file.writeLine(func + "(int(" + name + "));\n");
			else
				file.writeLine(func + "((int&)" + name + ");\n");
		}
		else {
			nl = &t->node()->nodes();
			for(nl->start(i); !nl->isEnd(i); nl->next(i)){
				pushPopVar(file, push, func, nl->get(i)->node(0), name + "." + nl->get(i)->node(1)->name());
			}
		}
//		printf("DoType: %p Derived(%p): Done\n", type, t->derived());
	}
	else if(type->nodeType() == Node::TTYPELIST){
		if(push){
			file.writeLine("{\n");
			file.indentMore();
			file.writeLine(BString("BIter i") + opushPopDepth + ";\n");
			file.writeLine(func + "(" + name + ".number());\n");
			s = BString("for(") + name + ".start(i" + opushPopDepth + "); !" + name + ".isEnd(i" + opushPopDepth + "); " + name + ".next(i" + opushPopDepth + ")){\n";
			file.writeLine(s);
			file.indentMore();
			pushPopVar(file, push, func, type->node(0), name + "[i" + opushPopDepth++ + "]");
			opushPopDepth--;
			file.indentLess();
			file.writeLine("}\n");
			file.indentLess();
			file.writeLine("}\n");
		}
		else {
			file.writeLine("{\n");
			file.indentMore();
			file.writeLine(BString("BUInt32 n") + opushPopDepth + ";\n");
			s = getTypeName(type->node(0)) + " v" + opushPopDepth + ";\n";
			file.writeLine(s);
			file.writeLine(name + ".clear();\n");
			file.writeLine(func + "(n" + opushPopDepth + ");\n");
			file.writeLine(BString("while(n") + opushPopDepth + "--){\n");
			file.indentMore();
			pushPopVar(file, push, func, type->node(0), BString("v") + opushPopDepth++);
			opushPopDepth--;
			file.writeLine(name + ".append(v" + opushPopDepth + ");\n");
			file.indentLess();
			file.writeLine("}\n");
			file.indentLess();
			file.writeLine("}\n");
		}
	}
	else if(type->nodeType() == Node::TTYPEDICT){
		BString	typeName = getTypeName(type->node(0));
		
		if(push){
			file.writeLine("{\n");
			file.indentMore();
			file.writeLine(BString("BDict<") + typeName + ">::iterator i" + opushPopDepth + ";\n");
			file.writeLine(func + "(" + name + ".size());\n");
			s = BString("for(") + name + ".start(i" + opushPopDepth + "); !" + name + ".isEnd(i" + opushPopDepth + "); " + name + ".next(i" + opushPopDepth + ")){\n";
			file.writeLine(s);
			file.indentMore();
			file.writeLine(func + "(" + name + ".key(i" + opushPopDepth + "));\n");
			pushPopVar(file, push, func, type->node(0), name + "[i" + opushPopDepth++ + "]");
			opushPopDepth--;
			file.indentLess();
			file.writeLine("}\n");
			file.indentLess();
			file.writeLine("}\n");
		}
		else {
			file.writeLine("{\n");
			file.indentMore();
			file.writeLine(BString("BUInt32 n") + opushPopDepth + ";\n");
			file.writeLine(BString("BString k") + opushPopDepth + ";\n");
			s = getTypeName(type->node(0)) + " v" + opushPopDepth + ";\n";
			file.writeLine(s);
			file.writeLine(name + ".clear();\n");
			file.writeLine(func + "(n" + opushPopDepth + ");\n");
			file.writeLine(BString("while(n") + opushPopDepth + "--){\n");
			file.indentMore();
			file.writeLine(func + "(k" + opushPopDepth + ");\n");
			pushPopVar(file, push, func, type->node(0), BString("v") + opushPopDepth++);
			opushPopDepth--;
			file.writeLine(name + "[k" + opushPopDepth + "] = v" + opushPopDepth + ";\n");
			file.indentLess();
			file.writeLine("}\n");
			file.indentLess();
			file.writeLine("}\n");
		}
	}
	else if(type->nodeType() == Node::TTYPEARRAY){
		// Check if raw data copy can be used

#ifdef ZAP
		printf("GenBoapPython::Checking For Raw Type: %s\n", getTypeName(type->node(0)).retStr());
		printf("GenBoapPython::IsRawType: %d\n", isRawType(type->node(0)));
		printf("\n");
#endif		

		if(isRawType(type->node(0))){
#ifdef ZAP
			printf("Push raw array of type: %s (%s)\n", getTypeName(type->node(0)).retStr(), getTypeSwapList(type->node(0)).retStr());
#endif
			swapType = getTypeSwapList(type->node(0));

			if(push){
				file.writeLine("{\n");
				file.indentMore();

				file.writeLine(func + "(" + name + ".size());\n");
				file.writeLine(func + "(" + name + ".size() * sizeof(" + getTypeName(type->node(0)) + "), " + name + ".data(), \"" + swapType + "\");\n");

				file.indentLess();
				file.writeLine("}\n");
			}
			else {
				file.writeLine("{\n");
				file.indentMore();

				file.writeLine(BString("BUInt32 n") + opushPopDepth + ";\n");
				file.writeLine(func + "(n" + opushPopDepth + ");\n");
				file.writeLine(name + ".resize(n" + opushPopDepth + ");\n");
				file.writeLine(func + "(n" + opushPopDepth + " * sizeof(" + getTypeName(type->node(0)) + "), " + name + ".data(), \"" + swapType + "\");\n");

				file.indentLess();
				file.writeLine("}\n");
			}
		}
		else {
			if(push){
				file.writeLine("{\n");
				file.indentMore();
				file.writeLine(BString("BUInt32 i") + opushPopDepth + ";\n");
				file.writeLine(func + "(" + name + ".size());\n");
				s = BString("for(i") + opushPopDepth + " = 0; i" + opushPopDepth + " < " + name + ".size(); i" + opushPopDepth + "++){\n";
				file.writeLine(s);
				file.indentMore();
				pushPopVar(file, push, func, type->node(0), name + "[i" + opushPopDepth++ + "]");
				opushPopDepth--;
				file.indentLess();
				file.writeLine("}\n");
				file.indentLess();
				file.writeLine("}\n");
			}
			else {
				file.writeLine("{\n");
				file.indentMore();
				file.writeLine(BString("BUInt32 n") + opushPopDepth + ";\n");
				s = getTypeName(type->node(0)) + " v" + opushPopDepth + ";\n";
				file.writeLine(s);
				file.writeLine(func + "(n" + opushPopDepth + ");\n");
				file.writeLine(name + ".resize(n" + opushPopDepth + ");\n");
				file.writeLine(BString("for(BUInt32 i = 0; i < n") + opushPopDepth + "; i++){\n");
				file.indentMore();
				pushPopVar(file, push, func, type->node(0), BString("v") + opushPopDepth++);
				opushPopDepth--;
				file.writeLine(name + "[i] = v" + opushPopDepth + ";\n");
				file.indentLess();
				file.writeLine("}\n");
				file.indentLess();
				file.writeLine("}\n");
			}
		}
	}
	else {
		file.writeLine(func + "(" + name + ");\n");
	}
}

void GenBoapPython::produceFunc(Node* n){
	BIter		i;
	BString		s;
	BList<Node*>*	nl;
	BString		retType;
	int		c;
	
	retType = getTypeName(n->node(0));
	
	ofileWrap.writeLine("PyObject*\to = 0;\n");
	ofileWrap.writeLine("PyObject*\tresult = 0;\n");
	ofileWrap.writeLine("DataAccess*\tobj = (DataAccess*)((BasicObject*)self)->obj;\n");
	ofileWrap.writeLine(retType + "\t\tret;\n");
	
	nl = &n->node(1)->nodes();
	for(nl->start(i), c = 0; !nl->isEnd(i); nl->next(i)){
		if((nl->get(i)->node(0)->name() == "in") || (nl->get(i)->node(0)->name() == "inout")){
			ofileWrap.writeLine(BString("PyObject*") + "\tpyarg_" + nl->get(i)->node(2)->name() + ";\n");
		}
		ofileWrap.writeLine(getTypeName(nl->get(i)->node(1), 0) + "\tcarg_" + nl->get(i)->node(2)->name() + ";\n");
		c++;
	}
	ofileWrap.writeLine("\n");

	for(nl->start(i), c = 0; !nl->isEnd(i); nl->next(i)){
		if((nl->get(i)->node(0)->name() == "in") || (nl->get(i)->node(0)->name() == "inout")){
			ofileWrap.writeLine(BString("if(!(pyarg_") + nl->get(i)->node(2)->name() + " = PyTuple_GetItem(args, " + c + "))) return 0;\n");
		}
		c++;
	}
	ofileWrap.writeLine("\n");

	for(nl->start(i), c = 0; !nl->isEnd(i); nl->next(i)){
		if((nl->get(i)->node(0)->name() == "in") || (nl->get(i)->node(0)->name() == "inout")){
//			ofileWrap.writeLine(BString("carg_") + nl->get(i)->node(2)->name() + " = convertTo" + getTypeName(nl->get(i)->node(1), 0) + "(pyarg_" + nl->get(i)->node(2)->name() + ");\n");
			ofileWrap.writeLine(BString("convert(pyarg_") + nl->get(i)->node(2)->name() + ", carg_" + nl->get(i)->node(2)->name() + ");\n");
		}
		c++;
	}
	ofileWrap.writeLine("\n");
	
	ofileWrap.writeLine("// CallFunc\n");
#ifndef ZAP
	s = s + "ret = ";
	s = s + "obj->";
	s = s + n->name() + "(";
	nl = &n->node(1)->nodes();
	for(nl->start(i); !nl->isEnd(i); nl->next(i)){
		if(i != nl->begin())
			s = s + ", ";
		s = s + "carg_" + nl->get(i)->node(2)->name();
	}
	s = s + ");\n";
	ofileWrap.writeLine(s);
	ofileWrap.writeLine("\n");
#endif

	ofileWrap.writeLine("result = PyInt_FromLong(33);\n");
	
	nl = &n->node(1)->nodes();
	for(nl->start(i), c = 0; !nl->isEnd(i); nl->next(i)){
		if((nl->get(i)->node(0)->name() == "out") || (nl->get(i)->node(0)->name() == "inout")){
//			ofileWrap.writeLine(BString("result = pythonAppendOutput(result, convertToPyObject(carg_") + nl->get(i)->node(2)->name() + "));\n");
			ofileWrap.writeLine(BString("convert(carg_") + nl->get(i)->node(2)->name() + ", o);\n");
			ofileWrap.writeLine(BString("result = pythonAppendOutput(result, o);\n"));
		}
	}
	
	ofileWrap.writeLine("return result;\n");
}

void GenBoapPython::produceImpWrap(Node* n){
	BString		s;
	BIter		i;
	BList<Node*>*	nl;
	BString		typeName;
	BString		t;

	switch(n->nodeType()){
	case Node::TMODULE:
		omodule = BString("lib") + n->name();
		
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceImpWrap(n->nodes()[i]);
		}
		break;

	case Node::TINTERFACE:
		ointerface = n->name();
		oclasses.append(ointerface);
		
		ofuncNum = 16;
		
		ofileWrap.writeLine(BString("static PyTypeObject type_") + ointerface + ";\n\n");

		// New functions
		ofileWrap.writeLine(BString("PyObject* function_") + ointerface + "_new(PyTypeObject* type, PyObject* args, PyObject* kwds){\n");
		ofileWrap.indentMore();
		ofileWrap.writeLine("BasicObject*\tobj;\n\n");
		ofileWrap.writeLine("obj = (BasicObject*)type->tp_alloc(type, 0);\n");
		ofileWrap.writeLine(BString("obj->obj = (void*)new ") + ointerface + ";\n");
		ofileWrap.writeLine("return (PyObject*)obj;\n");
		ofileWrap.indentLess();
		ofileWrap.writeLine("}\n\n");
		
		ofileWrap.writeLine(BString("void function_") + ointerface + "_del(_object* o){\n");
		ofileWrap.indentMore();
		ofileWrap.writeLine("BasicObject* obj = (BasicObject*)o;\n");
		ofileWrap.writeLine(BString("delete (") + ointerface + "*)obj->obj;\n");
		ofileWrap.writeLine("obj->ob_type->tp_free((PyObject*)obj);\n");
		ofileWrap.indentLess();
		ofileWrap.writeLine("}\n\n");

		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceImpWrap(n->nodes()[i]);
		}
		
		ofileWrap.writeLine(BString("static PyMethodDef methods_") + n->name() + "[] = {\n");
		ofileWrap.indentMore();
		BListLoop(oclassFunctions, i1){
			ofileWrap.writeLine(BString("{ \"") + oclassFunctions[i1] + "\", function_" + ointerface + "_" + oclassFunctions[i1] + ", METH_VARARGS, \"\" },\n");
		}
		ofileWrap.writeLine("{NULL}\n");
		ofileWrap.indentLess();
		ofileWrap.writeLine("};\n\n");
		oclassFunctions.clear();
		break;

	case Node::TLIST:
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceImpWrap(n->nodes()[i]);
		}
		break;
	case Node::TFUNC:
		oclassFunctions.append(n->name());
		
		ofileWrap.writeLine(BString("static PyObject* function_") + ointerface + "_" + n->name() + "(PyObject* self, PyObject *args){\n");
		ofileWrap.indentMore();
		produceFunc(n);
		ofileWrap.indentLess();
		ofileWrap.writeLine("};\n\n");
		ofuncNum++;
		break;
	case Node::TAPIVERSION:
		oapiVersion = n->name().retInt();
		break;

	case Node::TSTRUCT:
		if(n->name() == "BObj")
			return;

		typeName = BString("") + n->name();

#ifdef ZAP		
		if((n->nodes().number() == 2) && n->node(1)){
			ofilePython.writeLine(BString("class ") + typeName + "(" + getTypeName(n->node(1), 1) + "):\n");
		}
		else {
			ofilePython.writeLine(BString("class ") + typeName + ":\n");
		}
#endif

		oconvertors.writeLine(BString("BError convert(PyObject* v, ") + typeName + "& r){\n");
		oconvertors.indentMore();
		oconvertors.writeLine("BError err;\n");

		nl = &n->node(0)->nodes();
		if(nl->number()){
			for(nl->start(i); !nl->isEnd(i); nl->next(i)){
				t = getTypeName(nl->get(i)->node(0), 1);
				s = nl->get(i)->node(1)->name();
				oconvertors.writeLine(BString("convert(PyObject_GetAttrString(v, \"") + s + "\"), r." + s + ");\n");
			}
		}
		oconvertors.writeLine("return err;\n");
		oconvertors.indentLess();
		oconvertors.writeLine("}\n\n");

		oconvertors.writeLine(BString("BError convert(") + typeName + "& v, PyObject*& r){\n");
		oconvertors.indentMore();
		oconvertors.writeLine("BError err;\n");

		nl = &n->node(0)->nodes();
		if(nl->number()){
			for(nl->start(i); !nl->isEnd(i); nl->next(i)){
				t = getTypeName(nl->get(i)->node(0), 1);
				s = nl->get(i)->node(1)->name();
//				oconvertors.writeLine(BString("convert(PyObject_GetAttrString(v, \"") + s + "\"), r." + s + ");\n");
			}
		}
		oconvertors.writeLine("return err;\n");
		oconvertors.indentLess();
		oconvertors.writeLine("}\n\n");


		ofileWrap.writeString(oconvertors);
		oconvertors.clear();
		break;
	default:
		break;
	}
}

BString GenBoapPython::getTypeInitialiser(BString typeName){
	if(typeName == "BInt32"){
		return " = 0";
	}
	else if(typeName == "BUInt32"){
		return " = 0";
	}
	else return "";
}

BError GenBoapPython::produceHeaderWrap(){
	BError	err;

	ofileWrap.printf("/*******************************************************************************\n");
	ofileWrap.printf(" *\t%s\tProduced by Bidl\n", (ofileName + "_wrap.cpp").retStr());
	ofileWrap.printf(" *******************************************************************************\n");
	ofileWrap.printf(" */\n");
	ofileWrap.printf("\n");
	ofileWrap.printf("#include <BeamPython.h>\n");
	ofileWrap.printf("\n");

	ofileWrap.printf("\n");
	ofileWrap.printf("struct BasicObject {\n");
	ofileWrap.printf("\tPyObject_HEAD\n");
	ofileWrap.printf("\tvoid*	obj;\n");
	ofileWrap.printf("};\n\n");

	ofileWrap.printf("void typeInit(PyObject* module, PyTypeObject& obj, const char* nameFull, const char* name, PyMethodDef* methods){\n");
	ofileWrap.printf("\tobj.tp_name = nameFull;\n");
	ofileWrap.printf("\tobj.tp_basicsize = sizeof(BasicObject);\n");
	ofileWrap.printf("\tobj.tp_flags = Py_TPFLAGS_DEFAULT;\n");
	ofileWrap.printf("\tobj.tp_new = PyType_GenericNew;\n");
	ofileWrap.printf("\tobj.tp_methods = methods;\n");
	ofileWrap.printf("\tPyType_Ready(&obj);\n");
	ofileWrap.printf("\tPy_INCREF(&obj);\n");
	ofileWrap.printf("\tPyModule_AddObject(module, name, (PyObject*)&obj);\n");
	ofileWrap.printf("}\n\n");
	
	return err;
}

BError GenBoapPython::produceTrailerWrap(){
	BError	err;
	
	ofileWrap.printf("static PyMethodDef methods[] = {\n");
	BListLoop(ofunctions, i){
		ofileWrap.printf("\t%s\n", ofunctions[i].retStr());
	}
	ofileWrap.printf("\t{NULL, NULL, 0, NULL}\n\n");
	ofileWrap.printf("};\n\n");
	
	ofileWrap.printf("PyMODINIT_FUNC init%s(void){\n", omodule.retStr());
	ofileWrap.printf("\tPyObject* m = Py_InitModule(\"%s\", methods);\n\n", omodule.retStr());

	BListLoop(oclasses, i){
		const char*	name = oclasses[i].retStr();
		ofileWrap.printf("\ttypeInit(m, type_%s, \"%s\", \"%s\", methods_%s);\n", name, (omodule + "." + oclasses[i]).retStr(), name, name);
		ofileWrap.printf("\ttype_%s.tp_new = function_%s_new;\n", name, name);
		ofileWrap.printf("\ttype_%s.tp_dealloc = function_%s_del;\n", name, name);
		ofileWrap.printf("\tPyType_Ready(&type_%s);\n", name);
		ofileWrap.printf("\tPy_INCREF(&type_%s);\n", name);
		ofileWrap.printf("\tPyModule_AddObject(m, \"%s\", (PyObject*)&type_%s);\n", name, name);
		ofileWrap.printf("\n");
	}
	
	ofileWrap.printf("}\n");

	return err;
}

BString GenBoapPython::getTypeSwapList(Node* n){
	BString	typeName;
	Type*	t;
	BIter	i;
	BString	typeList;

	typeName = n->name();
//	printf("isRawType: %d %s\n", n->nodeType(), typeName.retStr());

	if(n->nodeType() == Node::TTYPEARRAY){
		return "";
	}
	else if(n->nodeType() == Node::TTYPEDICT){
		return "";
	}
	else if(n->nodeType() == Node::TTYPE){
		if(typeName == "Int8")		return "1";
		else if(typeName == "UInt8")	return "1";
		else if(typeName == "Int16")	return "2";
		else if(typeName == "UInt16")	return "2";
		else if(typeName == "Int32")	return "4";
		else if(typeName == "UInt32")	return "4";
		else if(typeName == "Bool")	return "4";
		else if(typeName == "String")	return "";
		else if(typeName == "Error")	return "";
		else if(typeName == "Date")	return "";
		else if(typeName == "DateTime")	return "";
		else if(typeName == "Id")	return "";
		else if(typeName == "ObjData")	return "";
		else if(typeName == "TimeStamp")	return "";
		else if(typeName == "Complex")	return "";
		else {
			if(t = gtypelist.search(typeName)){
				if(t->node()){
					return  getTypeSwapList(t->node());
				}
			}
			else
				return "";
		}
	}
	else if(n->nodes().number()){
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			typeList += getTypeSwapList(n->nodes()[i]);
		}

		return typeList;
	}
	return "";
}



GenBoapPython::GenBoapPython(){
	ofuncNum = 0;
	opushPopDepth = 0;
	oapiVersion = 0;
	
//	setUseBObjects(1);
}

GenBoapPython::~GenBoapPython(){
}

BError GenBoapPython::produce(Node* n, BString fileName){
	BError	err;
	
//	dprintf("GenBoapPython::produce: %x\n", n);
	ofileName = BString("lib") + fileName;
	ofilePython.open(ofileName + "D.py", "w");
	ofileWrap.open(ofileName + "_wrap.cpp", "w");
	
	// File Headers
	produceHeaderPython();
	produceHeaderWrap();
	
	// Generate code
	produceImpPython(n);
	produceImpWrap(n);
	
	// Generate trailers
	produceTrailerPython();
	produceTrailerWrap();
	ofilePython.close();
	ofileWrap.close();

	return err;
}

