/*******************************************************************************
 *	GenBoapMc.h	Generate output
 *			T.Barnaby,	BEAM Ltd,	2/5/03
 *******************************************************************************
 */
#ifndef GenBoapMc_H
#define GenBoapMc_H

#include <Gen.h>

class GenBoapMc : public Gen {
public:
			GenBoapMc();
			~GenBoapMc();
	BError		produce(Node* n, BString fileName);
private:
	BError		produceHeaderIntC();
	BError		produceHeaderIntS();
	BError		produceTrailerInt();
	BError		produceHeaderImpC();
	BError		produceHeaderImpS();

	void		produceIntC(Node* n);
	void		produceIntS(Node* n);
	void		produceImpC(Node* n);
	void		produceImpS(Node* n);

	void		produceFuncC(Node* n);
	void		produceFuncCall(Node* n);
	
	BString		getTypeSwapList(Node* n);

	BString		ofileName;
	FileIndent	ofileIntC;
	FileIndent	ofileIntS;
	FileIndent	ofileImpC;
	FileIndent	ofileImpS;
	BString		omodule;
	BString		ointerface;
	int		ofuncNum;
	int		opushPopDepth;
	int		oapiVersion;
};

#endif
