/*
* Title:	TmsDataMainWin.h
* Author:	M.Thomas BEAM Ltd
* Date:		2007-02-13
*
* Contents:	The main test Gui window
*
* Mod Rec:
*
*/

#ifndef	TMSDATAMAINWIN_H
#define TMSDATAMAINWIN_H	1


#include <AppGui.h>
#include <qtabwidget.h>
#include <BError.h>
#include <BString.h>
#include <OptionsWin.h>


class TmsDataMainWin: public AppGui {
	Q_OBJECT
public:
	TmsDataMainWin();
	~TmsDataMainWin();

	void	warningDialog(BString title,BError err,BString msg = "");	///< Warning dialog
public slots:
	void	slotQuit();				///< Exit the application
	void	slotNewConnection();			///< Create a new connection

private slots:
	void	slotEnterWhatsThis();			///< Enter Whats This mode
	void    slotPrefferences();			///< User wishes to configure setup	
	void	slotAbout();				///< Display the About dialog
	void	slotManual();				///< Display the online manual
	void	slotTmsManual();			///< Didplay Tms System Manual index
private:
	void	initMenubar();				///< Initialize menu bar
	void	initMain();				///< Initialize main widget
	void	initToolbar();				///< Initialize main widget
	
	OptionsWin*		ooptionsWin;
		
	QTabWidget*		otabd;			///< Tab widget controlling other widget panes
};
#endif
