/*
** <admxrc2/debugtst.h> - Scalar types used in ADMXRC2 Debug Timestampting extension.
**
** (C) Copyright 2016 Alpha Data
*/

#ifndef _ADATA_ADMXRC2_DEBUGTST_H
#define _ADATA_ADMXRC2_DEBUGTST_H

/* Timestampable facility identifiers (i.e. things that can have a timestamp data buffer) */
#define ADMXRC2_DEBUGTS_FACILITY_DMA(N) (N) /* DMA engine N */

/* If event type bit 7 is 1, it is a point-like event, with no duration */
/* If event type bit 7 is 0, it is an line-like event, with a duration. In that case, if bit 0 is 0, it is the start event and if 1 it is the finish event. */

/* Event types specific to ADMXRC2_DEBUGTS_FACILITY_DMA(N) */
#define ADMXRC2_DEBUGTS_EVENT_DMASETUPSTART      (0x0)  /* Setup of a DMA chunk starting */
#define ADMXRC2_DEBUGTS_EVENT_DMASETUPFINISH     (0x1)  /* Setup of a DMA chunk finished */
#define ADMXRC2_DEBUGTS_EVENT_DMATEARDOWNSTART   (0x2)  /* Teardown of a DMA chunk starting */
#define ADMXRC2_DEBUGTS_EVENT_DMATEARDOWNFINISH  (0x3)  /* Teardown of a DMA chunk finished */
#define ADMXRC2_DEBUGTS_EVENT_DMAHWSTART         (0x4)  /* Transfer of a DMA chunk on hardware starting */
#define ADMXRC2_DEBUGTS_EVENT_DMAHWFINISH        (0x5)  /* Transfer of a DMA chunk on hardware finished (interrupt) */
#define ADMXRC2_DEBUGTS_EVENT_DMADPC             (0x80) /* DPC scheduled by ISR has begun to execute */

/* Flags for 'Status' field of ADMXRC2_DEBUGTS_INFO */
#define ADMXRC2_DEBUGTS_STATUS_OVERFLOW (0x1U << 0)

/* Flags for 'flags' parameter of ADMXRC2_ReadDebugTS */
#define ADMXRC2_DEBUGTS_FLAG_CONSUME (0x1U << 0)

#endif
