/*
** <admxrc2/combuff.h> - Defines functions for ADMXRC2 API Direct Master common
**                       buffer extension.
**
** (C) Copyright 2003-2014 Alpha Data
*/

#ifndef _ADATA_ADMXRC2_COMBUFF_H
#define _ADATA_ADMXRC2_COMBUFF_H

#include <admxrc2.h>
#include <admxrc2/combuffs.h>

#ifdef __cplusplus
extern "C" {
#endif

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_GetCommonBufferInfo(
  ADMXRC2_HANDLE             hCard,
  unsigned int               index,
  ADMXRC2_COMMONBUFFER_INFO* pBufferInfo);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_SyncCommonBuffer(
  ADMXRC2_HANDLE             hCard,
  unsigned int               bufferIndex,
  unsigned long              offset,
  unsigned long              length,
  ADMXRC2_SYNCMODE           syncMode);

#ifdef __cplusplus
} 
#endif

#endif
