/*
** File: debugts.h  
** Project: ADMXRC2 module driver
** Purpose: Defines function prototypes for Debug Timestamping IOCTL handlers.
**
** (C) Copyright Alpha Data 2016
*/

#if !defined(ADATA_ADMXRC2_DEBUGTS_H)
#define ADATA_ADMXRC2_DEBUGTS_H

#include <df.h>
#include "device.h"
#include <admxrc2/types.h>

extern DfIoStatus
ioctlGetDebugTSInfo(
	Admxrc2DeviceContext* pDevCtx,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);

#if DF_NEED_THUNK
extern DfIoStatus
ioctlGetDebugTSInfoThunk(
	Admxrc2DeviceContext* pDevCtx,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);
#endif

extern DfIoStatus
ioctlGetDebugTSStatus(
	Admxrc2DeviceContext* pDevCtx,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);

#if DF_NEED_THUNK
extern DfIoStatus
ioctlGetDebugTSStatusThunk(
	Admxrc2DeviceContext* pDevCtx,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);
#endif

extern DfIoStatus
ioctlReadDebugTS(
	Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize);

#if DF_NEED_THUNK
extern DfIoStatus
ioctlReadDebugTSThunk(
	Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize);
#endif

extern DfIoStatus
ioctlResetDebugTS(
	Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize);

#endif
