/*
** File: combuf.h  
** Project: ADMXRC2 module driver
** Purpose: Defines function prototypes for common buffer IOCTL handlers.
**
** (C) Copyright Alpha Data 2014
*/

#if !defined(ADATA_ADMXRC2_COMBUF_H)
#define ADATA_ADMXRC2_COMBUF_H

#include <df.h>
#include "device.h"
#include <admxrc2/types.h>

extern DfIoStatus
ioctlGetCommonBufferInfo(
	Admxrc2DeviceContext* pDevCtx,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);

#if DF_NEED_THUNK
extern DfIoStatus
ioctlGetCommonBufferInfoThunk(
	Admxrc2DeviceContext* pDevCtx,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);
#endif

extern DfIoStatus
ioctlSyncCommonBuffer(
	Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);

#if DF_NEED_THUNK
extern DfIoStatus
ioctlSyncCommonBufferThunk(
	Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);
#endif

#if 0
extern DfIoStatus
ioctlGetCommonBufferCount(
	Admxrc2DeviceContext* pDevCtx,
  void* pBuffer,
  unsigned int outSize);
#endif

#endif
