/*
** File: shared_defs.h  
** Project: ADB3 core driver & module drivers
** Purpose: Centralizes location of important definitions. These defintions
**          are shared between the ADB3 core driver and the ADMXRC3 module
**          drivers etc.
**
** (C) Copyright Alpha Data 2009-2011
*/

#if !defined(_ADATA_CORE_SHARED_DEFS_H)
#define _ADATA_CORE_SHARED_DEFS_H

/* Maximum number of DMA engines found on any model */
#define MAX_NUM_DMA_ENGINE                      (4)

/* Maximum number of clock generators found on any model */
#define MAX_NUM_CLOCK_GENERATOR                 (9)

/* Maximum number of target FPGAs found on any model */
#define MAX_NUM_TARGET_FPGA                     (2)

/* Maximum number Flash devices found on any model */
#define MAX_NUM_FLASH_BANK                      (2)

/*
** Maximum number of Flash bootblocks in the target FPGA bitstream Flash devices found on any model.
**
** NOTE: For a stacked die device, this limit applies to each die in the stack. Hence a stacked die
**       Flash device may have MAX_NUM_FLASH_DIE_STACKED * MAX_NUM_FLASH_DEVICE_BOOTBLOCK
**       bootblocks.
*/
#define MAX_NUM_FLASH_DEVICE_BOOTBLOCK          (4)
#define MAX_NUM_FLASH_DIE_STACKED               (2)
#define MAX_NUM_FLASH_BOOTBLOCK                 (MAX_NUM_FLASH_DEVICE_BOOTBLOCK * MAX_NUM_FLASH_DIE_STACKED)

/* Maximum number of local bus windows found on any model */
#define MAX_NUM_LOCAL_BUS_WINDOW                (4)

/* Maximum number of sensors found on any model */
#define MAX_NUM_SENSOR                          (47)

/* Maximum number of I/O modules found on any model */
#define MAX_NUM_IO_MODULE                       (1)

/* The name of the core interface that is exported by the core driver and imported by module drivers */
static const char g_coreInterfaceName[] = "adb3core_rev0";

#endif
