/*
** File: pci9xxx_common.h  
** Project: ADB3 core driver
** Purpose: Exports functions common to models that use the PCI9080 or PCI9656
**          PCI to Local Bus Bridge.
**

** (C) Copyright Alpha Data 2013
*/

#ifndef _ADB3_CORE_PCI9XXX_COMMON_H
#define _ADB3_CORE_PCI9XXX_COMMON_H

#include "device.h"
#include "pci9xxx.h"

extern void
pci9xxxDumpDmaDescriptors(
  Adb3CoreDeviceContext* pDevCtx,
  Pci9xxxDmaDescriptor* pDescriptors,
  uint64_t descBus,
  unsigned int count);

extern void
pci9xxxDumpDmaRegisters(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int channel);

extern void
pci9xxxDmaList(
  Adb3CoreDeviceContext* pDevCtx,
  boolean_t bWriteToDevice,
  boolean_t bFixedLocal,
  DfDmaMapperNode* pTable,
  unsigned int tableLength,
  DmaNodeTablePosition* pTablePosition,
  void* pDescriptorBuffer,
  unsigned int maxDescriptor,
  uint64_t descriptorBusAddress);

extern void
pci9xxxDmaTransfer(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int channel,
  boolean_t bStart,
  void* pDescriptorBuffer,        /* Valid iff 'bStart' is TRUE */
  uint64_t descriptorBusAddress); /* Valid iff 'bStart' is TRUE */

extern void
pci9xxxEnableInterrupts(
  Adb3CoreDeviceContext* pDevCtx,
  boolean_t bEnable);

extern CoreWindowConfigStatus
pci9xxxGetWindowConfig(
	Adb3CoreDeviceContext* pDevCtx,
  unsigned int windowIndex,
  CoreWindowConfig* pConfig);

extern CoreWindowConfigStatus
pci9xxxSetWindowConfig(
	Adb3CoreDeviceContext* pDevCtx,
  unsigned int windowIndex,
  uint32_t flags,
  const CoreWindowConfig* pConfig);

extern CoreWindowConfigStatus
pci9xxxWindowConfig(
	Adb3CoreDeviceContext* pDevCtx,
  unsigned int windowIndex,
  boolean_t bConfigure,
  uint32_t flags,
  CoreWindowConfig* pConfig);

extern void
pci9xxxInitRegs(
  Adb3CoreDeviceContext* pDevCtx,
  boolean_t bEnableDirectMaster);

#endif
