/*
** File: ics8430_61.h  
** Project: ADB3 core driver
** Purpose: Exports functions for programming the ICS8430-61 clock generator.
**
** (C) Copyright Alpha Data 2013
*/

#ifndef _ADATA_CORE_ICS8430_61_H
#define _ADATA_CORE_ICS8430_61_H

#include "device.h"
#include "coreif.h"

struct _Adb3CoreDeviceContext;
struct _Ics8430_61ProgramRequest;
typedef struct _Ics8430_61ProgramRequest Ics8430_61ProgramRequest;
struct _Ics8430_61ProgramRequestSync;
typedef struct _Ics8430_61ProgramRequestSync Ics8430_61ProgramRequestSync;

typedef struct _Ics8430_61DeviceContext {
  DfTimer timer;       /* Timer for checking that clock synthesizer programming was successful */
	uint32_t* pReg;      /* Address of MCLKCTL register */
  DfMemoryHandle hReg; /* Handle to MCLKCTL register */
  struct { /* Used to save & restore state when powering down & up */
    CoreClockWord last;
    boolean_t bLastValid;
  } save;
} Ics8430_61DeviceContext;

typedef enum _Ics8430_61ClockWordStatus {
  Ics8430_61ClockWordStatusSuccess = 0,
  Ics8430_61ClockWordStatusOutOfRange = 1,
  Ics8430_61ClockWordStatusGeneralFailure = 2
} Ics8430_61ClockWordStatus;

typedef enum _Ics8430_61ProgramStatus {
  Ics8430_61ProgramStatusSuccess = 0,
  Ics8430_61ProgramStatusHardwareError = 1,
  Ics8430_61ProgramStatusGeneralFailure = 2
} Ics8430_61ProgramStatus;

typedef void Ics8430_61ProgramCallback(struct _Adb3CoreDeviceContext* pDevCtx, Ics8430_61DeviceContext* pIcs8430_61Ctx, Ics8430_61ProgramRequest* pRequest, Ics8430_61ProgramStatus status);

struct _Ics8430_61ProgramRequest {
  Ics8430_61DeviceContext* pIcs8430_61Ctx;
  Ics8430_61ProgramCallback* pCallback;
  CoreClockWord clockWord;
};

struct _Ics8430_61ProgramRequestSync {
  Ics8430_61ProgramRequest request;
  DfEvent ev;
  Ics8430_61ProgramStatus status;
};

#endif
