/*
** File: ics843034_01.h  
** Project: ADB3 core driver
** Purpose: Exports functions for programming the ICS843034_01 clock generator.
**
** (C) Copyright Alpha Data 2011
*/

#ifndef _ADATA_CORE_ICS843034_01_H
#define _ADATA_CORE_ICS843034_01_H

#include "device.h"
#include "coreif.h"

struct _Adb3CoreDeviceContext;
struct _Ics843034_01ProgramRequest;
typedef struct _Ics843034_01ProgramRequest Ics843034_01ProgramRequest;
struct _Ics843034_01ProgramRequestSync;
typedef struct _Ics843034_01ProgramRequestSync Ics843034_01ProgramRequestSync;

typedef struct _Ics843034_01DeviceContext {
  DfTimer timer;       /* Timer for checking that clock synthesizer programming was successful */
	uint32_t* pReg;      /* Address of MCLKCTL register */
  DfMemoryHandle hReg; /* Handle to MCLKCTL register */
  struct { /* Used to save & restore state when powering down & up */
    CoreClockWord last;
    boolean_t bLastValid;
  } save;
} Ics843034_01DeviceContext;

typedef enum _Ics843034_01ClockWordStatus {
  Ics843034_01ClockWordStatusSuccess = 0,
  Ics843034_01ClockWordStatusOutOfRange = 1,
  Ics843034_01ClockWordStatusGeneralFailure = 2
} Ics843034_01ClockWordStatus;

typedef enum _Ics843034_01ProgramStatus {
  Ics843034_01ProgramStatusSuccess = 0,
  Ics843034_01ProgramStatusHardwareError = 1,
  Ics843034_01ProgramStatusGeneralFailure = 2
} Ics843034_01ProgramStatus;

typedef void Ics843034_01ProgramCallback(struct _Adb3CoreDeviceContext* pDevCtx, Ics843034_01DeviceContext* pIcs834034_01Ctx, Ics843034_01ProgramRequest* pRequest, Ics843034_01ProgramStatus status);

struct _Ics843034_01ProgramRequest {
  Ics843034_01DeviceContext* pIcs843034_01Ctx;
  Ics843034_01ProgramCallback* pCallback;
  CoreClockWord clockWord;
};

struct _Ics843034_01ProgramRequestSync {
  Ics843034_01ProgramRequest request;
  DfEvent ev;
  Ics843034_01ProgramStatus status;
};

#endif
