/*
** File: flash.h  
** Project: ADB3 core driver
** Purpose: Interface to functions for identifying, reading, writing and erasing the
**          Flash devices on a card.
**
** (C) Copyright Alpha Data 2009-2010
*/

#if !defined(ADATA_CORE_FLASH_H)
#define ADATA_CORE_FLASH_H

#include <df.h>
#include "device.h"
#include "coreif.h"

extern CoreFlashStatus
flashErase(
    Adb3CoreDeviceContext* pDevCtx,
    unsigned int index,
    uint64_t start,
    uint64_t length);

extern CoreFlashStatus
flashIdentifyBlock(
    Adb3CoreDeviceContext* pDevCtx,
    unsigned int index,
    uint64_t location,
    uint64_t* pBlockStart,
    uint64_t* pBlockSize);

extern CoreFlashStatus
flashRead(
    Adb3CoreDeviceContext* pDevCtx,
    unsigned int index,
    uint64_t start,
    size_t length,
    void* pBuffer);

extern CoreFlashStatus
flashSync(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int index);

extern CoreFlashStatus
flashWrite(
    Adb3CoreDeviceContext* pDevCtx,
    unsigned int index,
    uint64_t start,
    size_t length,
    const void* pData);

#endif
