/*
** File: coreflash.h  
** Project: ADB3 core driver
** Purpose: Defines function prototypes for Flash programming in Core Interface.
**
** (C) Copyright Alpha Data 2009-2010
*/

#if !defined(ADATA_CORE_COREFLASH_H)
#define ADATA_CORE_COREFLASH_H

#include <df.h>
#include "device.h"
#include "coreif.h"

extern CoreFlashStatus
coreFlashErase(
  void* pInterfaceContext,
  CoreTicket* pTicket,
  unsigned int flashIndex,
  uint64_t offset,
  uint64_t length);

extern CoreFlashStatus
coreFlashRead(
  void* pInterfaceContext,
  CoreTicket* pTicket,
  unsigned int flashIndex,
  uint64_t offset,
  size_t length,
  void* pBuffer);

extern CoreFlashStatus
coreFlashSync(
  void* pInterfaceContext,
  CoreTicket* pTicket,
  unsigned int flashIndex);

extern CoreFlashStatus
coreFlashWrite(
  void* pInterfaceContext,
  CoreTicket* pTicket,
  unsigned int flashIndex,
  uint64_t offset,
  size_t length,
  const void* pBuffer);

extern CoreFlashStatus
coreGetFlashInfo(
  void* pInterfaceContext,
  unsigned int flashIndex,
  CoreFlashInfo* pFlashInfo);

extern CoreFlashStatus
coreGetFlashBlockInfo(
  void* pInterfaceContext,
  unsigned int flashIndex,
  uint64_t address,
  CoreFlashBlockInfo* pBlockInfo);

extern unsigned int
coreGetNumFlashBank(
  void* pInterfaceContext);

#endif
