/*
** File: coredmabus.h  
** Project: ADB3 core driver
** Purpose: Defines function prototypes for DMABus transfers in Core Interface.
**
** (C) Copyright Alpha Data 2011
*/

#if !defined(ADATA_CORE_COREDMABUS_H)
#define ADATA_CORE_COREDMABUS_H

#include <df.h>
#include "device.h"
#include "coreif.h"

/* Will be called holding the lock for a DMA channel */
extern void
dmaCompletedBus(
  Adb3CoreDeviceContext* pDevCtx,
  DmaChannelContext* pDmaContext,
  unsigned int channelIndex,
  DfSpinLockFlags f);

extern CoreDmaStatus
coreDmaBusCancel(
  void* pInterfaceContext,
  CoreTicket* pTicket,
  unsigned int channelIndex);

extern CoreDmaStatus
coreDmaBusInitialize(
  void* pInterfaceContext,
  CoreTicket* pTicket,
  unsigned int channelIndex,
  const CoreDmaBusParameters* pParameters,
  CoreDmaCallback* pCallback,
  void* pCallbackContext);

extern void
coreDmaBusStart(
  void* pInterfaceContext,
  CoreTicket* pTicket,
  unsigned int channelIndex);

extern unsigned int
coreGetNumDmaChannel(
  void* pInterfaceContext);

#endif
