/*
** File: corecombuf.c  
** Project: ADB3 core driver
** Purpose: Common Buffer Core Interface functions.
**
** (C) Copyright Alpha Data 2014
*/

#include <df.h>
#include "device.h"
#include "corecombuf.h"

unsigned int
coreGetNumCommonBuffer(
  void* pInterfaceContext)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;

  return pDevCtx->comBuf.count;
}

CoreCommonBufferStatus
coreGetCommonBufferInfo(
  void* pInterfaceContext,
  unsigned int commonBufferIndex,
  CoreCommonBufferInfo* pInfo)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;
  DfDmaBuffer* pDmaBuffer;

  if (commonBufferIndex >= pDevCtx->comBuf.count) {
    return CoreCommonBufferInvalidIndex;
  } else {
    pDmaBuffer = pDevCtx->comBuf.pComBufs[commonBufferIndex];
    pInfo->busBase = pDmaBuffer->busAddress;
    pInfo->pKernelBase = pDmaBuffer->pKernelAddress;
    pInfo->size = pDmaBuffer->size;
    return CoreCommonBufferSuccess;
  }
}

CoreCommonBufferStatus
coreSyncCommonBuffer(
  void* pInterfaceContext,
  unsigned int commonBufferIndex,
  boolean_t bDmaWrite,
  size_t offset,
  size_t length)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;
  DfDmaBuffer* pDmaBuffer;

  if (commonBufferIndex >= pDevCtx->comBuf.count) {
    return CoreCommonBufferInvalidIndex;
  } else {
    pDmaBuffer = pDevCtx->comBuf.pComBufs[commonBufferIndex];
    if (dfDmaBufferSync(pDmaBuffer, bDmaWrite, offset, length)) {
      return CoreCommonBufferSuccess;
    } else {
      return CoreCommonBufferInvalidRegion;
    }
  }
}
