/*
** File: avr_clock_common.h  
** Project: ADB3 core driver
** Purpose: Exports routines for programing clock generators via the
**          AVR uC
**
** (C) Copyright Alpha Data 2012
**
** These functions will not work if the AVR uC is in service mode.
** If not in service mode, the result of calling these functions will be
** AvrClockServiceMode.
*/

#ifndef _ADATA_CORE_AVR_CLOCK_COMMON_H
#define _ADATA_CORE_AVR_CLOCK_COMMON_H

#include "avr_clock.h"

/* Must be called in thread context */
extern boolean_t
avrClockInit(
  AvrClockContext* pAvrClockCtx,
  AvrDeviceContext* pAvrDevCtx,
  unsigned int numClock,
  uint32_t* pFInit);

/* Must be called in thread context */
extern void
avrClockUninit(
  AvrClockContext* pAvrClockCtx);

extern AvrClockStatus
avrClockGetFrequency(
  AvrClockContext* pAvrClockCtx,
  AvrClockRequest* pRequest,
  unsigned int index,
  AvrClockGetFrequencyCallback* pCallback,
  void* pContext);

extern AvrClockStatus
avrClockSetFrequency(
  AvrClockContext* pAvrClockCtx,
  AvrClockRequest* pRequest,
  unsigned int index,
  const CoreClockWord* pClockWord,
  AvrClockSetFrequencyCallback* pCallback,
  void* pContext);

/* Must be called in thread context */
extern AvrClockStatus
avrClockGetFrequencySync(
  AvrClockContext* pAvrClockCtx,
  unsigned int index,
  uint32_t* pFrequency);

/* Must be called in thread context */
extern AvrClockStatus
avrClockSetFrequencySync(
  AvrClockContext* pAvrClockCtx,
  unsigned int msIndex,
  const CoreClockWord* pClockWord);

/* Must be called in thread context */
extern void
avrClockSaveState(
  AvrClockContext* pAvrClockCtx);

/* Must be called in thread context */
extern AvrClockStatus
avrClockRestoreState(
  AvrClockContext* pAvrClockCtx);

/* Convenience functions */

extern ClockProgramStatus
avrClockMapStatus(
  AvrClockStatus status);

#endif
