/*
** File: avr2_clock_common.h  
** Project: ADB3 core driver
** Purpose: Exports routines for programing clock generators via the
**          AVR2 interface.
**
** (C) Copyright Alpha Data 2015
**
** These functions will not work if the AVR uC is in service mode.
** If not in service mode, the result of calling these functions will be
** Avr2ClockServiceMode.
*/

#ifndef _ADATA_CORE_AVR2_CLOCK_COMMON_H
#define _ADATA_CORE_AVR2_CLOCK_COMMON_H

#include "avr2_clock.h"

/* Must be called in thread context */
extern boolean_t
avr2ClockInit(
  Avr2ClockContext* pAvr2ClockCtx,
  Avr2DeviceContext* pAvr2DevCtx,
  unsigned int numClock,
  uint32_t* pFInit);

/* Must be called in thread context */
extern void
avr2ClockUninit(
  Avr2ClockContext* pAvr2ClockCtx);

extern Avr2ClockStatus
avr2ClockGetFrequency(
  Avr2ClockContext* pAvr2ClockCtx,
  Avr2ClockRequest* pRequest,
  unsigned int index,
  Avr2ClockGetFrequencyCallback* pCallback,
  void* pContext);

extern Avr2ClockStatus
avr2ClockSetFrequency(
  Avr2ClockContext* pAvr2ClockCtx,
  Avr2ClockRequest* pRequest,
  unsigned int index,
  const CoreClockWord* pClockWord,
  Avr2ClockSetFrequencyCallback* pCallback,
  void* pContext);

/* Must be called in thread context */
extern Avr2ClockStatus
avr2ClockGetFrequencySync(
  Avr2ClockContext* pAvr2ClockCtx,
  unsigned int index,
  uint32_t* pFrequency);

/* Must be called in thread context */
extern Avr2ClockStatus
avr2ClockSetFrequencySync(
  Avr2ClockContext* pAvr2ClockCtx,
  unsigned int msIndex,
  const CoreClockWord* pClockWord);

/* Must be called in thread context */
extern void
avr2ClockSaveState(
  Avr2ClockContext* pAvr2ClockCtx);

/* Must be called in thread context */
extern Avr2ClockStatus
avr2ClockRestoreState(
  Avr2ClockContext* pAvr2ClockCtx);

/* Convenience functions */

extern ClockProgramStatus
avr2ClockMapStatus(
  Avr2ClockStatus status);

#endif
