/*
** File: adpexrc4fx.h  
** Project: ADB3 core driver
** Purpose: Definitions specific to ADPE-XRC-4FX
**
** (C) Copyright Alpha Data 2013
*/

#if !defined(_ADATA_CORE_ADPEXRC4FX_H)
#define _ADATA_CORE_ADPEXRC4FX_H

#include "adb1.h"

#define ADPEXRC4FX_NUM_DMA_CHANNEL (2U)

#pragma pack(1)
/* BAR1 registers */
typedef struct _ModelRegsAdpexrc4fx {
  uint32_t _reserved1[2];      /* 0x000 */
  uint32_t lclk;               /* 0x008 */
  uint32_t mclk;               /* 0x00C */
  uint32_t _reserved2;         /* 0x010 */
  uint32_t fpctl;              /* 0x014 */
  uint8_t fpsmap[4];           /* 0x018 */
  uint32_t _reserved3;         /* 0x01C */
  uint32_t ictl;               /* 0x020 */
  uint32_t istat;              /* 0x024 */
  uint32_t pwrctl;             /* 0x028 */
  uint32_t flctl;              /* 0x02C */
  uint32_t flpage;             /* 0x030 */
  uint32_t fldata;             /* 0x034 */
  uint32_t _reserved4[2];      /* 0x038 */
  uint32_t monctl;             /* 0x040 */
  uint8_t mondata[60];         /* 0x044 */
  uint32_t _reserved5[32];     /* 0x080 */
  uint8_t _reserved6[1024];    /* 0x100 */
  uint8_t sysmonbuf[0x100];    /* 0x500 */
  uint8_t _reserved7[0x200];   /* 0x600 */
} ModelRegsAdpexrc4fx;         /* 0x800 */
#pragma pack()

/* Fields for ModelRegsAdpexrc4fx::fpctl */
#define ADPEXRC4FX_FPCTL_PROG   (0x1U << 0)
#define ADPEXRC4FX_FPCTL_INIT   (0x1U << 1)
#define ADPEXRC4FX_FPCTL_DONE   (0x1U << 2)

/* Fields for ModelRegsAdpexrc4fx::ictl */
#define ADPEXRC4FX_ICTL_ENFPGA   (0x1U << 0) /* Enable target FPGA interrupt */

/* Fields for ModelRegsAdpexrc4fx::istat */
#define ADPEXRC4FX_ISTAT_IRQFPGA (0x1U << 0) /* Target FPGA interrupt */

/* Number of sensors */
#define ADPEXRC4FX_NUM_LM87_SENSOR (9U)

/* Always LITTLE ENDIAN when stored in hardware */
#pragma pack(1)
typedef struct _VpdAdpexrc4fxRev0 {
  uint16_t version;             /* 0x00 */
  uint16_t boardType;           /* 0x02 */
  uint32_t modifications;       /* 0x04 */
  uint8_t stepping;             /* 0x08 */
  uint8_t reserved1[3];         /* 0x09 */
  uint32_t scd;                 /* 0x0C */
  uint32_t refClk;              /* 0x10 */
  uint32_t lclkRef;             /* 0x14 */
  uint32_t mclkRef;             /* 0x18 */
  uint32_t _reserved2;          /* 0x1C */
  struct {
    uint8_t order;              /* 0x20, 0x22, 0x24, 0x26 */
    uint8_t _reserved3;         /* 0x21, 0x23, 0x25, 0x27 */
  } sdram[4];
  uint32_t cardId;              /* 0x28 */
  uint32_t serialNumber;        /* 0x2C */
  uint16_t fpgaType;            /* 0x30 */
  uint8_t pcbRev;               /* 0x32 */
  uint8_t cpldRev;              /* 0x33 */
} VpdAdpexrc4fxRev0;            /* 0x34 */
#pragma pack()

/* Always LITTLE ENDIAN when stored in hardware */
#pragma pack(1)
typedef struct _VpdAdpexrc4fxRev1 {
  VpdAdpexrc4fxRev0 rev0;       /* 0x00 */
  struct {
    uint8_t order;              /* 0x34 */
    uint8_t _reserved1;         /* 0x35 */
  } ssram;
} VpdAdpexrc4fxRev1;            /* 0x36 */
#pragma pack()

/* Address and size of VPD region in Flash */
#define ADPEXRC4FX_VPD_OFFSET_IN_FLASH (0U)
#define ADPEXRC4FX_VPD_SIZE_IN_FLASH   (0x20000U)

/* Beginning of useable area in Flash for storing target bitstreams */
#define ADPEXRC4FX_FLASH_TARGET_AREA_START (0x800000U)

#endif
