/*
** File: adcbbp.h  
** Project: ADB3 core driver
** Purpose: Definitions specific to ADC-BBP
**
** (C) Copyright Alpha Data 2014
*/

#if !defined(_ADATA_CORE_ADCBBP_H)
#define _ADATA_CORE_ADCBBP_H

#include "adb1.h"

#define ADCBBP_NUM_DMA_CHANNEL (4U)

typedef struct _ModelRegsAdcbbp {
  uint32_t _reserved1[4];        /* 0x00000 */
  uint32_t lclkctl;              /* 0x00010 */
  uint32_t lclkstat1;            /* 0x00014 */
  uint32_t lclkstat2;            /* 0x00018 */
  uint32_t lclkstat3;            /* 0x0001C */
  uint32_t _reserved2[2];        /* 0x00020 */
  uint32_t ictl;                 /* 0x00028 */
  uint32_t istat;                /* 0x0002C */
  uint32_t _reserved3[2];        /* 0x00030 */
  uint32_t phyctl;               /* 0x00038 */
  uint32_t _reserved4[1];        /* 0x0003C */
  uint8_t  fpsmap0[4];           /* 0x00040 */
  uint32_t fpctl0;               /* 0x00044 */
  uint32_t _reserved5[2];        /* 0x00048 */
  uint8_t  fpsmap1[4];           /* 0x00050 */
  uint32_t fpctl1;               /* 0x00054 */
  uint32_t _reserved6[42];       /* 0x00058 */
  uint32_t flctl;                /* 0x00100 */
  uint32_t flpage;               /* 0x00104 */
  uint32_t fldata;               /* 0x00108 */
  uint32_t _reserved7[189];      /* 0x0010C */
  uint32_t sysmonctl;            /* 0x00400 */
  uint32_t _reserved8[63];       /* 0x00404 */
  uint8_t  sysmonbuf[0x100];     /* 0x00500 */
  uint8_t  _reserved9[0x3FA00];  /* 0x00600 */
} ModelRegsAdcbbp;               /* 0x40000 */

/* Fields for ModelRegsAdcbbp::fpctl{0,1} */
#define ADCBBP_FPCTLx_PROG   (0x1U << 0)
#define ADCBBP_FPCTLx_INIT   (0x1U << 1)
#define ADCBBP_FPCTLx_DONE   (0x1U << 2)
#define ADCBBP_FPCTLx_RELOAD (0x1U << 31)

/* Fields for ModelRegsAdcbbp::ictl */
#define ADCBBP_ICTL_ENFPGA(index) (0x1U << (index)) /* Enable target FPGA interrupt */

/* Fields for ModelRegsAdcbbp::istat */
#define ADCBBP_ISTAT_IRQFPGA(index) (0x1U << (index)) /* Target FPGA interrupt */

/* Address and size of VPD region in Flash */
#define ADCBBP_VPD_OFFSET_IN_FLASH (0x1000000U)
#define ADCBBP_VPD_SIZE_IN_FLASH   (0x20000U)

/* Beginning of useable area in Flash for storing target bitstreams */
#define ADCBBP_FLASH_TARGET_AREA_START (0x2000000U)

/* Always LITTLE ENDIAN when stored in hardware */
#pragma pack(1)
typedef struct _VpdAdcbbpRev0 {
  uint16_t  version;             /* 0x00 */
  uint16_t  _reserved1;          /* 0x02 */
  uint32_t  modifications;       /* 0x04 */
  uint8_t   stepping[2];         /* 0x08 */
  uint8_t   tempGrade;           /* 0x0A */
  uint8_t   _reserved2;          /* 0x0B */
  uint32_t  scd[2];              /* 0x0C */
  uint32_t  lclkRef;             /* 0x14 */
  uint32_t  mclkAFreq;           /* 0x18 */
  uint32_t  _reserved3;          /* 0x1C */
  struct {
    uint8_t order;               /* 0x20, 0x22, 0x24, 0x26 */
    uint8_t type;                /* 0x21, 0x23, 0x25, 0x27 */
  } zbt0[4];
  uint32_t  _reserved4[2];       /* 0x28 */
  struct {
    uint8_t order;               /* 0x30, 0x32, 0x34, 0x36 */
    uint8_t type;                /* 0x31, 0x33, 0x35, 0x37 */
  } zbt1[4];
  uint32_t  _reserved5[2];       /* 0x38 */
  uint32_t  cardId;              /* 0x40 */
  uint32_t  serialNumber;        /* 0x44 */
  uint16_t  fpgaType[2];         /* 0x48 */
  uint8_t   pcbRev;              /* 0x4C */
  uint8_t   logicRev;            /* 0x4D  Not actually read from VPD memory; constructed from PCI rev. ID */
  uint8_t   _reserved6[2];       /* 0x4E */
} VpdAdcbbpRev0;                 /* 0x50 */
#pragma pack()

#endif
