#if !defined(_ADATA_PORTABLE_STRING_H)
#define _ADATA_PORTABLE_STRING_H

/*
** File: portable_string.h
** Project: API libraries
** Purpose: Defines portability functions used by API libraries
**
** (C) Copyright Alpha Data 2011
*/

#include <portability.h>

extern void
portableStringCat(
  char* pDst,
  size_t max,
  const char* pSrc);

extern void
portableStringCopy(
  char* pDst,
  size_t max,
  const char* pSrc);

extern void
portableStringLower(
  char* pString,
  size_t bufSize);

extern void
portableStringUpper(
  char* pString,
  size_t bufSize);

extern int
portableStringCompareA(
  const char* pString1,
  const char* pString2);

extern size_t
portableStringLengthA(
  const char* pDst,
  size_t max);

#endif
