-- =============================================================================================
--                             	                                                            **
-- =============================================================================================
--	Title: adp_pupe_pkg.vhd
--	Description:	VHDL  design file for
--
--	Mod Record
--	===========
--	1)08/03/2007 13:53		adp_pupe_pkg created
--
-- (C) Copyright Alpha Data Parallel Systems Ltd. 1999-2007
--
--
-------------------------------------------------------------------------------------------------




--********************************************************************************************



library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;




package adp_pupe_pkg is


--********************************************************************************************
--	Attribute definitions
--********************************************************************************************




--********************************************************************************************




--********************************************************************************************
--	Constant Definitions
--********************************************************************************************

--=================================
-- Major memory space subdivisions
--=================================
constant 	CNTRL_SPACE :std_logic_vector :=X"0";
constant 	ACQCOUNT_SPACE :std_logic_vector :=X"1";
constant 	ADCDATA_SPACE :std_logic_vector :=X"2";
constant 	RDCOUNT_SPACE :std_logic_vector :=X"3";


constant 	MEM1_SPACE :std_logic_vector :=X"C";
constant 	MEM2_SPACE :std_logic_vector :=X"D";
constant 	MEM3_SPACE :std_logic_vector :=X"E";
constant 	MEM4_SPACE :std_logic_vector :=X"F";
----------------------------------





--=================================
-- ContrOl space registers
--=================================
constant 	RESET_REG :std_logic_vector      :=X"0";
constant 	LOC_ARM_REG :std_logic_vector    :=X"1";
constant 	LOC_TRIG_REG :std_logic_vector   :=X"2";
constant 	OVR_STATUS_REG :std_logic_vector :=X"3";
constant 	LOC_CMPLT_REG :std_logic_vector  :=X"4";


constant 	MASTER_IO_REG :std_logic_vector  :=X"5";
constant 	BKPLANE_IO_REG :std_logic_vector  :=X"6";
constant 	HDR_IO_REG :std_logic_vector     :=X"7";
constant 	RDEXT_IO_REG :std_logic_vector  :=X"8";
constant 	SYNTH_CNTRL_REG :std_logic_vector  :=X"9";
constant 	SYNTH_STRB_REG :std_logic_vector  :=X"A";

constant 	BANK1_CNTRL_REG :std_logic_vector  :=X"B";
constant 	BANK2_CNTRL_REG :std_logic_vector  :=X"C";
constant 	BANK3_CNTRL_REG :std_logic_vector  :=X"D";
constant 	BANK4_CNTRL_REG :std_logic_vector  :=X"E";

constant 	LOC_TEST_REG :std_logic_vector   :=X"F";
----------------------------------









constant 	DCM_ADV_PERIOD :real   :=8.0;




	--9 channels each 14 bits wide
	constant	ADC_CHANCNT	:natural :=9;
	constant	ADC_WIDTH	:natural :=14;

--********************************************************************************************

--********************************************************************************************
--	Type Definitions
--********************************************************************************************
	type SLV_ARRAY_ADCCHAN is array(ADC_CHANCNT-1 downto 0) of std_logic_vector(ADC_WIDTH-1 downto 0);
	type SLV_ARRAY_ADC32W is array(ADC_CHANCNT-1 downto 0) of std_logic_vector(31 downto 0);
type SLV_ARRAY_ADC16W is array(ADC_CHANCNT-1 downto 0) of std_logic_vector(15 downto 0);



--********************************************************************************************




--********************************************************************************************
--	Component Definitions
--********************************************************************************************

			--=================================
			-- DDR op reg, async set/reset, in IOB
			-- no OBUF
			--=================================
			component IOB_OFDDRCPE is
									port (
									Q : out STD_ULOGIC;
									C0 : in STD_ULOGIC;
									C1 : in STD_ULOGIC;
									CE : in STD_ULOGIC;
									D0 : in STD_ULOGIC;
									D1 : in STD_ULOGIC;
									CLR : in STD_ULOGIC;
									PRE : in STD_ULOGIC
									);

			end component IOB_OFDDRCPE ;
			----------------------------------



--********************************************************************************************







end package adp_pupe_pkg;
--********************************************************************************************






--********************************************************************************************
-- Procedures/Functions
--********************************************************************************************
package body adp_pupe_pkg is



end package body adp_pupe_pkg;

--********************************************************************************************










































--==============================================================================================
-- OFDDRCPE without an Obuf being instantiated as part of the component
-- Use FDDRCPE and pack in IOB
-- Typically used with an IOBUF
--==============================================================================================
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_signed.all;


-- synthesis translate_off
--needed for functional simulation
library UNISIM;
use UNISIM.all;
-- synthesis translate_on

--Define the entity.
--C0 and C1 are the input clocks.
ENTITY IOB_OFDDRCPE IS
						port (
						Q : out STD_ULOGIC;
						C0 : in STD_ULOGIC;
						C1 : in STD_ULOGIC;
						CE : in STD_ULOGIC;
						D0 : in STD_ULOGIC;
						D1 : in STD_ULOGIC;
						CLR : in STD_ULOGIC;
						PRE : in STD_ULOGIC
						);

END IOB_OFDDRCPE ;

ARCHITECTURE xil_comps OF IOB_OFDDRCPE  IS

		--component defintion must be local
		component FDDRCPE
		-- synthesis translate_off
		generic (INIT : bit := '1');
		-- synthesis translate_on
		port (
					Q : out STD_ULOGIC;
					C0 : in STD_ULOGIC;
					C1 : in STD_ULOGIC;
					CE : in STD_ULOGIC;
					CLR : in STD_ULOGIC;
					D0 : in STD_ULOGIC;
					D1 : in STD_ULOGIC;
					PRE : in STD_ULOGIC
				);
		end component;


	attribute INIT : string;
	-- values can be (0 or 1)
	attribute INIT of U0 : label is "0";




-- Make sure the flip flops are packed in the IO
	--Synplify
--	attribute syn_useioff : boolean;
--	attribute syn_useioff of U0 : label is true;
	--XST
	attribute iob: string;
	attribute iob of U0:label is "true";

BEGIN

	U0: FDDRCPE
			port map (
							Q		=> Q,
							C0	=> C0,
							C1	=> C1,
							CE	=> CE,
							D0	=> D0,
							D1	=> D1,
							CLR		=> CLR,
							PRE		=> PRE
					);
end xil_comps;

------------------------------------------------------------------------------------------------



