-------------------------------------------------------------------------------
-- Copyright (c) 2005 Xilinx, Inc.
-- This design is confidential and proprietary of Xilinx, All Rights Reserved.
-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  / Vendor: Xilinx
-- \   \   \/ Version: 1.6
--  \   \ Application : MIG
--  /   / Filename: mem_interface_small_wr_data_fifo_16.vhd
-- /___/   /\ Date Last Modified:  Wed Jun 1 2005
-- \   \  /  \Date Created: Mon May 2 2005
--  \___\/\___\
-- 
-- Device: Virtex-4
-- Design Name: DDR2_V4
-- Description  : This module instantiates the block RAM based FIFO to store 
-- 			the user interface data into it and read after a specified 
-- 			amount in already written. The reading starts when the 
--			almost full signal is generated whose offset is programmable.
-------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

library UNISIM;
use UNISIM.VCOMPONENTS.ALL;

entity mem_interface_small_wr_data_fifo_16 is
port(
       clk0 		 : in std_logic;
       clk90             : in std_logic;	 
       rst    		 : in std_logic;
       --Write data fifo signals
       app_Wdf_data 	 : in std_logic_vector(31 downto 0);
       app_mask_data     : in std_logic_vector(3 downto 0);              
       app_Wdf_WrEn 	 : in std_logic;
       ctrl_Wdf_RdEn 	 : in std_logic;
       Wdf_data 	       : out std_logic_vector(31 downto 0);
       mask_data         : out std_logic_vector(3 downto 0);
       wr_df_almost_full : out std_logic
       );
end entity;
                      
architecture arc_wr_data_fifo_16 of mem_interface_small_wr_data_fifo_16 is 

component FIFO16
generic ( ALMOST_FULL_OFFSET 	: bit_vector ;
          ALMOST_EMPTY_OFFSET : bit_vector ;
          DATA_WIDTH : integer ;
          FIRST_WORD_FALL_THROUGH : boolean );
  port(
    ALMOSTEMPTY : out std_logic;
    ALMOSTFULL  : out std_logic;
    DO          : out std_logic_vector (31 downto 0);
    DOP         : out std_logic_vector (3 downto 0);
    EMPTY       : out std_logic;
    FULL        : out std_logic;
    RDCOUNT     : out std_logic_vector (11 downto 0);
    RDERR       : out std_logic;
    WRCOUNT     : out std_logic_vector (11 downto 0);
    WRERR       : out std_logic;
    DI          : in  std_logic_vector (31 downto 0);
    DIP         : in  std_logic_vector (3 downto 0);
    RDCLK       : in  std_logic;
    RDEN        : in  std_logic;
    RST         : in  std_logic;
    WRCLK       : in  std_logic;
    WREN        : in  std_logic
    );
  end component;
                      



signal ctrl_Wdf_RdEn_270 : std_logic;
signal ctrl_Wdf_RdEn_90  : std_logic;

begin         

process(clk90)
begin
if clk90'event and clk90 = '0' then
          ctrl_Wdf_RdEn_270 <= ctrl_Wdf_RdEn;
  end if;
end process;

process(clk90)
begin
if clk90'event and clk90 = '1' then
          ctrl_Wdf_RdEn_90 <= ctrl_Wdf_RdEn_270;
   end if;
end process;

Wdf_1 : FIFO16
generic map( 
 ALMOST_FULL_OFFSET       => X"00F",
 ALMOST_EMPTY_OFFSET  	  => X"007",
 DATA_WIDTH          	  => 36,
 FIRST_WORD_FALL_THROUGH  => FALSE
 )
         port map (
           ALMOSTEMPTY       => open, 
           ALMOSTFULL        => wr_df_almost_full, 
           DO                => Wdf_data(31 downto 0), 
           DOP               => mask_data(3 downto 0), 
           EMPTY             => open, 
           FULL              => open, 
           RDCOUNT           => open, 
           RDERR             => open, 
           WRCOUNT           => open, 
           WRERR             => open, 
           DI                => app_Wdf_data(31 downto 0), 
           DIP               => app_mask_data(3 downto 0), 
           RDCLK             => clk90, 
           RDEN              => ctrl_Wdf_RdEn_90, 
           RST               => rst, 
           WRCLK             => clk0, 
           WREN              => app_Wdf_WrEn
          );


end arc_wr_data_fifo_16;

