/*
* Title:	PupeSimulateWin.h
* Author:	M.Thomas BEAM Ltd
* Date:		2007-04-03
*
* Contents:	Pupe Simulation mode setup
*
* Mod Rec:
*
*/

#ifndef PUPESIMULATE_H
#define PUPESIMULATE_H

#include <BString.h>
#include <qhbox.h>
#include <Control.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qpushbutton.h>
#include <BQComboBox.h>

/*! Configure System and setup user interface window. 
*
*/
class PupeSimulateWin : public QWidget {
        Q_OBJECT
public:
        PupeSimulateWin(QWidget* w,Control& c);
	~PupeSimulateWin();
public slots:
	void	show();					///< Update and make the widget visible

	void	loadRam();				///< Load Pupe channel with simulation data from file
	void	clearRam();				///< Clear simulation data
	void 	initialiseTMS();			///< Initialise the TMS server
	void 	applyInternalTimings();			///< Apply modification to the signals generated internally in the FPGA
	void 	applySimulation();			///< Apply modification to the simulation settings
	void 	applyCycleType();			///< Apply changed or new cycle type data


private slots:
	void	update();				///< Update the GUI to reflect current Server status
	BError	updateTimingMask();			///< Update GUI with internal timings 
	BError	updateControlList();			///< Update GUI with available cycle types
	BError	updateMaxChannels();			///< Update GUI with the maximum available PUPE channels
	void	selectFile();
	
private:
	void		warningDialog(BString title, BError err);
	Control&	ocontrol;

	QCheckBox*	oallChannels;
	QSpinBox*	ochannel;
	
	QPushButton*	oloadSimulationRam;
	QPushButton*	oclearSimulationRam;
	QLineEdit*	osimulationRamFilename;

	BQComboBox*	ocycleType;

	QPushButton*	oapplyCycleType;

	QCheckBox*	oClock;
	QCheckBox*	oCycleStart;
	QCheckBox*	oCycleStop;
	QCheckBox*	oCalStart;
	QCheckBox*	oCalStop;
	QCheckBox*	oInjection;
	QCheckBox*	oHChange;
	QCheckBox*	oFref;

	QCheckBox*	oadcSysclkSync;
	QCheckBox*	odisableBlr;

	QPushButton*	oiApply;
	QPushButton*	oInitialise;

	QCheckBox*	osimTiming;
	QCheckBox*	osimData;
	QCheckBox*	osimNextCycle;
	QCheckBox*	osimDoubleInjection;
	QPushButton*	osApply;


};
#endif
