/*******************************************************************************
 *	Server.cc	HomeNet RPC protocol test server
 *			T.Barnaby,	BEAM Ltd,	9/5/03
 *******************************************************************************
 */
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <BString.h>
#include <TestD.h>
#include <TestS.h>

void hd(void* data, int nb){
	unsigned char*	p = (unsigned char*)data;
	int		n = 0;
	
	while(n < nb){
		printf("%2.2x ", *p++);
		n++;
		if((n & 0xF) == 0)
			printf("\n");
	}
}

class Server : public Test::Obj1Service {
public:
		Server(BoapServer& server, BString name) : Test::Obj1Service(server, name){}
	BError	setData(Int32 a1);
	BError	getData(Int32& a1);
	BError	setData1(Int32 a1, Test::Data a2);
	BError	getData1(Int32& a1, Test::Data& a2);
private:
	Int32		oa1;
	Test::Data	oa2;
};

BError	Server::setData(Int32 a1){
	BError	err;
	
	oa1 = a1;

	return err;
}

BError	Server::getData(Int32& a1){
	BError	err;
	
	a1 = oa1;
	
	return err;
}

BError	Server::setData1(Int32 a1, Test::Data a2){
	BError	err;

	oa1 = a1;
	oa2 = a2;
	
	return err;
}

BError	Server::getData1(Int32& a1, Test::Data& a2){
	BError	err;

	a1 = oa1;
	a2 = oa2;
	
	return err;
}

int main(int argc, char** argv){
	BoapServer		server;
	Server			obj1(server, "test");
	BError			err;

	printf("Server Starting\n");	
	if(err = server.init("beam.beamnet", BoapServer::NOTHREADS)){
		std::cerr << err.getString() << "\n";
		return 1;
	}

	server.run();
	
	return 0;
}
