/*******************************************************************************
 *	BObject.h	Beam Object
 *			T.Barnaby,	BEAM Ltd,	15/7/92
 *******************************************************************************
 */
#ifndef BOBJECT_H
#define BOBJECT_H	1

#include	<BType.h>
#include	<BDataBuf.h>
#include	<BString.h>
#include	<BNameValue.h>
#include	<BList.h>
#include	<BError.h>


class BObject;

typedef BNameValue<BObject*>		BMember;
typedef BNameValueList<BObject*>	BMemberList;

class BObject {
public:
				BObject();
	virtual			~BObject();
	
	// Data Storage Functions
	virtual	BError		getBinary(BDataBuf& buf);
	virtual	BError		setBinary(BDataBuf& buf);

	// Object info Functions
	virtual BString		getString();
	virtual BError		setString(BString str);

	virtual	BMemberList	getMemberList();
	virtual	BError		addMember(BString name, BObject* object);
#ifdef ZAP
	// Object access functions
	BObject*	getMember(BString name);
	BError		setMember(BString name, BObject* value);
	BString		getMemberString(BString name);
	BError		setMemberString(BString name, BString value);
#endif
	virtual void		printIt();
public:
	virtual BType&		getType();
	static BObject*		createObj();
	static BType		otype;
};

#endif
