/*******************************************************************************
 *	BThread.h	BThread Classes
 *			T.Barnaby,	BEAM Ltd,	31/3/00
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BTHREAD_H
#define BTHREAD_H	1

#include <pthread.h>

class BThread {
public:
			BThread();
	virtual		~BThread();
	
	// Prior to start setup
	int		setInitPriority(int policy, int priority);
	int		setInitStackSize(size_t stackSize);

	int		start();
	void*		result();
	int		running();
	
	int		setPriority(int policy, int priority);
	int		cancel();
	void*		waitForCompletion();
	pthread_t	getThread();
	
	virtual void*	function();
private:
	static void*	startFunc(void*);

	pthread_t	othread;
	size_t		ostackSize;
	int		opolicy;
	int		opriority;
	int		orunning;
	void*		oresult;
};

#endif
