#!/usr/bin/env python
################################################################################
#	PlotFile.py	Signal plotter
#			T.Barnaby,	BEAM Ltd,	2006-02-10
################################################################################
#

import sys
import getopt
import math
import Gnuplot
import array

def sigFileReadAscii(fileName, numSamples):
	d = Numeric.zeros(numSamples, Numeric.Float32);
	f = open(fileName);
	for i in range(0, numSamples):
		l = f.readline();
		if(l == ""):
			break;
		d[i] = float(l);
	
	return d[0:i];

def sigFileRead(fileName, numSamples):
	f = open(fileName, "r");
	s = os.fstat(f.fileno());
	if(numSamples > (s.st_size / (24 * 4))):
		numSamples = s.st_size / (24 * 4);
	
	d = array.array("f");
	d.fromfile(f, 24 * numSamples);
	
	sig24 = Numeric.zeros((24, numSamples), Numeric.Float32);
	for i in range(0, numSamples):
		for c in range(0, 24):
			sig24[c][i] = d[i * 24 + c];
	
	return sig24;

def plotSig1(fileName, toFile=""):
	g = Gnuplot.Gnuplot();

	g('set multiplot');
	g('set format x ""');
	g('set lmargin 8');
	g('set bmargin 0');
	g('set tmargin 1');
	g('set grid noytics xtics');
	g('set data style lines');


#	g('set size 1.0,1.0');
	g('set data style lines');
	g('set grid');
	g('set mouse');
	if(toFile != ""):
		g('set term png');
		g("set output '" + toFile + "'");
		

	d1 = Gnuplot.Data(sig);
	g('set xlabel "Sample"');
	if(sigRange != ""):
		g('set xrange [' + sigRange + ']');
	g.plot(d1);
	
	if(toFile == ""):
		raw_input('Please press return to continue...\n');

def plotSig(fileName, toFile=""):
	g = Gnuplot.Gnuplot();

	g('set multiplot');
	g('set format x ""');
	g('set lmargin 8');
	g('set bmargin 0');
	g('set tmargin 1');
	g('set grid noytics xtics');
	g('set data style lines');

	g.plot("diag_injection_0g.txt");
	
	if(toFile == ""):
		raw_input('Please press return to continue...\n');

def usage():
	print "Usage: filePlot.py [ -p <file> ] <signal file>";
	print "		-p <file>	- Create graphics file (.png)"
	
def main():
	toFile		= "";
				
	try:
		opts, args = getopt.getopt(sys.argv[1:], "p:");
	except getopt.GetoptError:
        	# print help information and exit:
        	usage();
        	sys.exit(1);

	for o in opts:
		if(o[0] == "-p"):
			toFile = o[1];
		else:
			usage();

	if(len(args) != 1):
		usage();
		sys.exit(1);

	plotSig(args[0]);
		
	sys.exit(0);
	
if __name__ == "__main__":
	main();
