/***************************************************************************
 *	TmsStateGui.h	TMS Cycle parameters State display
 *			T.Barnaby,	BEAM Ltd,	2007-11-13
 ***************************************************************************
 */
#ifndef	TmsStateGui_H
#define TmsStateGui_H	1

#include <BError.h>
#include <BString.h>
#include <TmsCycleParam.h>
#include <BGraph.h>
#include <qvbox.h>
#include <qgrid.h>
#include <qtabwidget.h>
#include <qspinbox.h>
#include <qtextview.h>
#include <qlineedit.h>
#include <qscrollbar.h>
#include <qpushbutton.h>

class TmsStateGui: public QVBox {
	Q_OBJECT
public:
	TmsStateGui(QWidget* p);
	~TmsStateGui();

	void	init();					///< Initialise

public slots:
	BError	view(Tms::CycleParamEdit& cycleParam, int reset);
	void	update();
	void	scroll();
	void	zoomIn();
	void	zoomOut();

private:
	void	zoom(int in);

	QScrollBar*		oscrollBar;
	QPushButton*		ozoomIn;
	QPushButton*		ozoomOut;
	QGrid*			oinfoBox;
	QSpinBox*		ostate;
	QLineEdit*		ostateInfo;
	QLineEdit*		ostateField0;
	QLineEdit*		ostateField1;

	Tms::CycleParamEdit	ocycleParam;
	BArray<BGraph*>		ographs;
	unsigned int		opos;
	unsigned int 		orange;
	unsigned int		orangeMax;
};
#endif
