/*******************************************************************************
 *	SigGen.h	Signal Generator classes
 *			T.Barnaby,	BEAM Ltd,	2006-09-12
 *******************************************************************************
 */

#ifndef SigGen_h
#define SigGen_h	1

#include <BList.h>
#include <BError.h>


typedef	float	Sample;
	

class BSignal {
public:
	enum		{ NumChannels = 9 };
			BSignal(int id = 0, int numSamples = 0, int numRepeat = 0, int nextId = 0);
			BSignal(const BSignal& sig);
			~BSignal();
	BSignal&	operator=(const BSignal& sig);
		
	int		id;
	int		numSamples;
	int		numRepeat;
	int		nextId;
	Sample*		data[NumChannels];
};

typedef BList<BSignal> BSignalList;

class SigGen {
public:
			SigGen();
	virtual		~SigGen();
	
	BError		config(double sampleRate);
	virtual BError	generate(Sample* data, int numSamples);

protected:
	double			osampleRate;
	unsigned long long	ox;
};


class SigGenSine : public SigGen {
public:
		SigGenSine();
	virtual	~SigGenSine();
	
	BError	config(double sampleRate, double freq, double amplitude = 1.0);
	
	BError	generate(Sample* data, int numSamples);

public:
	double	ofreq;
	double	oamplitude;
};

class SigGenSquare : public SigGen {
public:
		SigGenSquare();
	virtual	~SigGenSquare();
	
	BError	config(double sampleRate, double freq, double amplitude = 1.0, double offset = 0.0);
	
	BError	generate(Sample* data, int numSamples);

public:
	double	ofreq;
	double	oamplitude;
	double	ooffset;
};

class SigGenNoise : public SigGen {
public:
		SigGenNoise();
	virtual	~SigGenNoise();
	
	BError	config(double sampleRate, double amplitude = 1.0);
	
	BError	generate(Sample* data, int numSamples);

public:
	double	oamplitude;
};

class SigGenPulse : public SigGen {
public:
		SigGenPulse();
	virtual	~SigGenPulse();
	
	BError	config(double sampleRate, double freq, double amplitude, double onTime, double startTime = 0.0);
	
	BError	generate(Sample* data, int numSamples);

public:
	double	ofreq;
	double	oamplitude;
	double	oonTime;
	double	ostartTime;
};

class SigGenBeam : public SigGen {
public:
		SigGenBeam();
	virtual	~SigGenBeam();
	
	BError	config(double sampleRate, double fref, int harmonic, int bunchSet, double reduce, int blr, double amplitude);
	
	BError	generate(Sample* data, int numSamples);
	BError	generateIntegrated(Sample* data, int numSamples);

public:
	int	oharmonic;
	int	obunchSet;
	double	oreduce;
	int	oblr;
	double	oamplitude;
	double	ofref;
};

#endif
