/*******************************************************************************
 *	NetworkHttp.h		NetworkHttp class
 *			T.Barnaby,	BEAM Ltd,	2006-08-01
 *******************************************************************************
 */
#ifndef NetworkHttp_H
#define NetworkHttp_H	1

#include <stdint.h>
#include <BError.h>
#include <BSocket.h>
#include <BThread.h>
#include <BHtmlPage.h>
#include <TmsC.h>

using namespace Tms;

class Control;
class NetworkHttp;

class HttpConnection : public BSocket, private BThread {
public:
	enum		{ BufSize = 8192 };

			HttpConnection(Control& control, int fd, BSocketAddressINET from);
			~HttpConnection();

	void		start();

private:
	void*		function();
	BError		initTms();
	BError		process();
	BError		processFile(BString url);
	BError		processInternal(BString url);
	BError		createPage(BHtmlPage& page);
	
	BError		recvLine(BString& line);
	BError		sendString(BString line);
	BError		sendHttpError(int num, BString str);
	BError		sendHeader(int num, BString contentType = "text/plain");
	BString		encodeString(BString str);
	BString		decodeString(BString str, int option);
	
	BError		plotData(BString dataFileName, int channel, BString name, BString outFileName);
	BString		htmlStrip(BString str);
	
	Control&		ocontrol;
	BString			ohtmlDir;
	BSocketAddressINET	ofrom;
	FILE*			ofile;
	TmsControl		otmsControl;
	TmsProcess		otmsProcess;
};

class NetworkHttpThread : public BThread {
public:
		NetworkHttpThread(NetworkHttp& netOutput);
	void*	function();
private:
	NetworkHttp&	onetOutput;
};

class NetworkHttp : public BSocket {
public:
			NetworkHttp(Control& control);
			~NetworkHttp();
	
	// Main control functions		
	BError		init();
	BError		start();
	BError		stop();
	
	// Statistics Functions

	// Thread execution
	BError		run();

private:
	Control&		ocontrol;
	NetworkHttpThread	orunThread;

	BList<HttpConnection*>	oconnections;
};

#endif
