/*******************************************************************************
 *	PllSynth.cc	PLL Synthesisor control
 *			T.Barnaby,	BEAM Ltd,	2007-09-05
 *******************************************************************************
 *	From code developed by: DMc
 */
#ifndef PllSynth_H
#define PllSynth_H	1

#include <BError.h>

class PllSynth {
public:
	enum		Mode { VCXO, VCXO_REF };
	
			PllSynth();
	
	BError		init(volatile uint32_t* fpgaAddress);		///< Initialises the PllSynth
	BError		setMode(Mode mode);				///< Sets the PLL mode
	int		lockStatus();					///< Returns lock status
	void		lockReset();					///< Resets the lock detect system

	void		displayRegisters();
private:
	volatile uint32_t*	ofpga;
};

#endif
