/*
* Title:	PhaseTableWin.h
* Author:	M.Thomas BEAM Ltd
* Date:		2007-04-03
*
* Contents:	Pupe Simulation mode setup
*
* Mod Rec:
*
*/

#ifndef PHASETABLEWIN_H
#define PHASETABLEWIN_H

#include <BString.h>
#include <qhbox.h>
#include <Control.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qpushbutton.h>
#include <qtextedit.h>
#include <qlistbox.h>
#include <qtable.h>
#include <qlayout.h>
#include <qvbox.h>
#include <qgroupbox.h>
#include <qvgroupbox.h>
#include <qdialog.h>

#include <BQComboBox.h>

#include <TmsD.h>
#include <TmsC.h>
#include <TmsS.h>
#include <TmsLib.h>
#include <TmsCycleParam.h>
#include <TmsStateGui.h>

class DetailViewGui : public QDialog {
        Q_OBJECT
public:
			DetailViewGui();
	void		init(Tms::CycleParamEdit& cycleParam, int reset);
public:
	TmsStateGui*	ostateGui;
};

class CycleParamStateGui : public Tms::CycleParamState {
public:
	UInt32	enable;
};


/*! Configure System and setup user interface window. 
*
*/
class PhaseTableWin : public QWidget {
        Q_OBJECT
public:
        PhaseTableWin(QWidget* w,Control& c);
	~PhaseTableWin();

public slots:
	void	show();

private slots:
	void    update();			///< update Gui element to reflect current data
	BError  updateCycleTypes(); 		///< Updates known Server cycle types list
	void    updateCycleInfo(); 		///< Updates GUI to reflect selected cycle type
	void    updateCycleParamState(); 	///< Update GUI to reflect Cycle Param data
	
	

	void	loadFromFile();			///< Load cycle info from file
	void	loadFromTms();			///< Load cycle info from the server
	void	saveFile();			///< Save cycle defs file on file system
	void	saveTms();			///< Save cycle defs on remote TMS server
	void	deleteTms();			///< Delete cycle defs from remote TMS server
	void	updateDetails();		///< Updates the details
	void	viewDetails();			///< Save cycle defs file on file system

	void	addOffsets();			///< Add offest to all items in the phase delay table
	void	loadDefaults();			///< Load defaults for phase delays
	
	
	void 	enableStateEdit();
	void	setCyclePhaseParams();

	void	selectFile();			///< Invoke dialog to select a cycle definition file

	void	cycleStateChanged();
	void	cycleStateChanged(int num);
	void	addNextState();
	void	delLastState();

private:
	void	refreshParamState(Tms::CycleParamState s);
	
	void	createGridGroupBox(QVGroupBox*& g,BString title,QWidget*& w,QGridLayout*& l);
	void	addEditorToGrid(QGridLayout* g,QWidget* w,BString label,QWidget* editor,int row,int col, int colEnd = 0);
	
	
	void		setParams();
	
	
	QString		uIntToStr(UInt32 v);
	QString		doubleToStr(double v);
	QString		uIntToHexStr(UInt32 v);
	
	void		warningDialog(BString title, BError err);
	int		confirmDialog(BString title, BString msg);

	Control&		ocontrol;
	
	QLineEdit*		ocycleType;
	QLineEdit*		oname;
	QSpinBox*		ochannel;
	QSpinBox*		oring;
	QLineEdit*		oinfo;
	QLineEdit*		opllCycleStartFrequency;
	QLineEdit*		opllInitialFrequency;
	QLineEdit*		opllInitialFrequencyDelay;
	QLineEdit*		opllFrefGain;
	QLineEdit*		opllGain;
	QLineEdit*		opllDdsMinimum;
	QLineEdit*		opllDdsMaximum;
	QLineEdit*		ostateDelay;

	QSpinBox*		ooffset;

	QLineEdit*		ofilename;

	QListBox*		ocycleTypes;
	QPushButton*		oselectFile;
	QPushButton*		oloadFromFile;
	QPushButton*		oloadFromTms;

	
	QPushButton*		oupload;
	QPushButton*		osaveFile;
	QPushButton*		odelete;
	QPushButton*		oupdate;
	QPushButton*		oviewDetails;

	QTable*			ophaseDelays;
	QPushButton*		oloadDefaults;
	QPushButton*		oaddOffsets;

	QCheckBox*		oenableModifications;
	QSpinBox*		ostateNum;
	QComboBox*		ophaseNames;
	QPushButton*		oaddNextState;
	QPushButton*		odelLastState;
	
	QVGroupBox * 		ostateSetups;

	QSpinBox*		onextStates[6];

	QLineEdit*		olo1Harmonic;
	QLineEdit*		olo1Phase;
	QLineEdit*		olo2Harmonic;
	QLineEdit*		olo2Phase;

	QCheckBox*		of1Ref;
	QCheckBox*		of1Lo;
	QCheckBox*		of2Ref;
	QCheckBox*		of2Lo;
	QCheckBox*		obit6;
	QCheckBox*		obit7;
	QCheckBox*		opllF2;
	QCheckBox*		oacquireData;

	QLineEdit*		obunchMask;
	QLineEdit*		omean1Mask;
	QLineEdit*		omean2Mask;
	QLineEdit*		ogateWidth;
	QLineEdit*		ogatePhase;
	QLineEdit*		oblrWidth;
	QLineEdit*		oblrPhase;

	BList<Tms::CycleParamState> 	ocycleStates;
	Tms::CycleParamEdit	oparams;
	DetailViewGui*		odetailViewGui;
};
#endif
