/*******************************************************************************
 *	TmsCycleParam.h	TMS Client library functions
 *			T.Barnaby,	BEAM Ltd,	2007-06-19
 *******************************************************************************
 */

#ifndef TmsCycleParam_H
#define TmsCycleParam_H		1

#include <TmsLib.h>

namespace Tms {


class CycleParamState {
public:
		CycleParamState();
	void	clear();		///< Clear the entry
	
	BString	getString();	///< Returns the CycleParamState in string form
	BError	setString(BString str);	///< Sets the CycleParamState from a string
		
	UInt32	period;		///< The cycle period
	UInt32	bunchMask;	///< The set of bunches to capture bit mask
	UInt32	mean1Mask;	///< The set of bunches to pass through meanFilter1
	UInt32	mean2Mask;	///< The set of bunches to pass through meanFilter2
	
	UInt32	loHarmonic;	///< The LO harmonic number used in this state
	double	loPhase;	///< The phase offset of the LO as a fraction of FREF (+-1.0)
	int	useLoFref;	///< Flag setting system to use LO as FREF rather than phase table address MSB
	int	acquireData;	///< Flag to acquire data during this state
	double	gateWidth;	///< The gate pulse width as a fraction of LO (0 - 1.0)
	double	gatePhase;	///< The gate phase offset as a fraction of LO (0 - 1.0)
	double	blrWidth;	///< The gate pulse width as a fraction of LO (0 - 1.0)
	double	blrPhase;	///< The gate phase offset as a fraction of LO (0 - 1.0)
};

/// Cycle Parameter management class
class CycleParamEdit : public CycleParam {
public:
			CycleParamEdit();
			CycleParamEdit(const CycleParam& param);
	
	void		clear();

	BString		getString();					///< Gets the Cycle Parameters in a string format for writing to a file or display
	BError		setString(BString str);				///< Sets the Cycle Parameters from a string. For reading from a file
				
	BError		readFromFile(BString fileName);			///< Reads the Cycle Parameters from a file
	BError		writeToFile(BString fileName);			///< Writes the Cycle Parameters to a file

	BError		setStates(BList<CycleParamState> cycleStates);	///< Sets the Cycle Parameter states given the state information list.
	BError		getStates(BList<CycleParamState>& cycleStates);	///< Returns the state information list describing the Cycle Parameter states. These may not be present.

	static void	getDefaultState(CycleParamState& state);	///< Get the default settings for a state.
	static void	getdefaultPickupPositions(BArray<Int32>& pos);	///< Get the default pickup positions.

private:
	double		value(int numSamples, int harmonic, double phase, int sample);
	int		bunch(int numSamples, int harmonic, double phase, int sample);
	BError		generateState(int num, Tms::TmsState state, CycleParamState stateParam, int lo1Harmonic, double lo1Phase, int lo2Harmonic, double lo2Phase);
};

}
#endif
