/*******************************************************************************
 *	BRWLock.h	BRWLock Classes
 *			T.Barnaby,	BEAM Ltd,	3/07/03
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BRWLOCK_H
#define BRWLOCK_H	1

#include <pthread.h>

/// thread read-write locks
class BRWLock {
public:
			BRWLock();
			BRWLock(const BRWLock& rwlock);
			~BRWLock();
	
	int		rdLock();	///< Set lock, wait if necessary
	int		tryRdLock();	///< Test the lock
	int		wrLock();	///< Set lock, wait if necessary
	int		tryWrLock();	///< Test the lock
	int		unlock();	///< Unlock the lock
	
	BRWLock&	operator=(const BRWLock& rwlock);
private:
	pthread_rwlock_t	olock;
};

#endif
