-------------------------------------------------------------------------------
-- Copyright (c) 2005 Xilinx, Inc.
-- This design is confidential and proprietary of Xilinx, All Rights Reserved.
-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  / Vendor: Xilinx
-- \   \   \/ Version: 1.6
--  \   \ Application : MIG
--  /   / Filename: mem_interface_small_data_path_0.vhd
-- /___/   /\ Date Last Modified:  Wed Jun 1 2005
-- \   \  /  \Date Created: Mon May 2 2005
--  \___\/\___\
-- 
-- Device: Virtex-4
-- Design Name: DDR2_V4
-- Description     : This module instantiates the tap logic and the data write 
-- 			   modules. Gives the rise and the fall data and the calibration 
--			   information for the IDELAY elements.
-------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;
use work.mem_interface_small_parameters_0.all;
-- pragma translate_off
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
-- pragma translate_on

entity mem_interface_small_data_path_0 is 
port (
      CLK                  : in std_logic;
      CLK90                : in std_logic;
      CAL_CLK              : in std_logic;
      RESET0               : in std_logic;
      RESET90              : in std_logic;
      RESET_CAL_CLK        : in std_logic;
      CTRL_DUMMYREAD_START : in std_logic;
      idelay_ctrl_rdy      : in std_logic;      
      WDF_DATA             : in std_logic_vector(dq_width*2-1 downto 0);
      MASK_DATA            : in std_logic_vector(dm_width*2-1 downto 0);      
      CTRL_WREN            : in std_logic;
      CTRL_DQS_RST         : in std_logic;
      CTRL_DQS_EN          : in std_logic;
      dqs_delayed          : in std_logic_vector(data_strobe_width-1 downto 0);
      CTRL_DUMMY_WR_SEL    : in std_logic;
      dummy_write_flag	   : in std_logic;
      wr_data_rise         : out std_logic_vector(data_width-1 downto 0);
      wr_data_fall         : out std_logic_vector(data_width-1 downto 0);
      mask_data_rise       : out std_logic_vector(data_mask_width-1 downto 0);
      mask_data_fall       : out std_logic_vector(data_mask_width-1 downto 0);      
      wr_en                : out std_logic; 
      dqs_rst              : out std_logic; 
      dqs_en               : out std_logic; 
      dqs_idelay_inc       : out std_logic_vector(ReadEnable-1 downto 0);
      dqs_idelay_ce        : out std_logic_vector(ReadEnable-1 downto 0);
      dqs_idelay_rst       : out std_logic_vector(ReadEnable-1 downto 0);

      data_idelay_inc      : out std_logic_vector(ReadEnable-1 downto 0);
      data_idelay_ce       : out std_logic_vector(ReadEnable-1 downto 0);
      data_idelay_rst      : out std_logic_vector(ReadEnable-1 downto 0);
      
      SEL_DONE             : out std_logic
      );
end entity;

architecture arc_data_path of mem_interface_small_data_path_0 is

component mem_interface_small_data_write_0
	
port (
      CLK                  : in std_logic;
      CLK90                : in std_logic;
      RESET0               : in std_logic;
      RESET90              : in std_logic;
      
      WDF_DATA             : in std_logic_vector(dq_width*2-1 downto 0);
      MASK_DATA            : in std_logic_vector(dm_width*2-1 downto 0);
      CTRL_WREN            : in std_logic;
      CTRL_DQS_RST         : in std_logic;
      CTRL_DQS_EN          : in std_logic;
      CTRL_DUMMY_WR_SEL    : in std_logic;     
      wr_data_fall         : out std_logic_vector(dq_width-1 downto 0);
      wr_data_rise         : out std_logic_vector(dq_width-1 downto 0);
      mask_data_fall       : out std_logic_vector(data_mask_width-1 downto 0);
      mask_data_rise       : out std_logic_vector(data_mask_width-1 downto 0);
      wr_en        	   : out std_logic;
      dqs_rst              : out std_logic;   
      dqs_en           	   : out std_logic   
      
      );
end component;


component mem_interface_small_tap_logic_0 
port (
      CLK                  : in std_logic;
      CAL_CLK              : in std_logic;
      RESET0               : in std_logic;
      RESET_CAL_CLK        : in std_logic;
      CTRL_DUMMYREAD_START : in std_logic;
      idelay_ctrl_rdy      : in std_logic;
      dqs_delayed          : in std_logic_vector(data_strobe_width-1 downto 0);
      
      dqs_idelay_inc       : out std_logic_vector(ReadEnable-1 downto 0); 
      dqs_idelay_ce        : out std_logic_vector(ReadEnable-1 downto 0); 
      dqs_idelay_rst       : out std_logic_vector(ReadEnable-1 downto 0); 
      data_idelay_inc      : out std_logic_vector(ReadEnable-1 downto 0); 
      data_idelay_ce       : out std_logic_vector(ReadEnable-1 downto 0); 
      data_idelay_rst      : out std_logic_vector(ReadEnable-1 downto 0); 
      SEL_DONE             : out std_logic
      );
end component;





begin 
 
  
  data_write_10 : mem_interface_small_data_write_0
    port map   (
                     CLK               => CLK,
                     CLK90             => CLK90,
                     RESET0            => RESET0,
                     RESET90           => RESET90,
                     WDF_DATA          => WDF_DATA,
                     MASK_DATA         => MASK_DATA,
                     CTRL_WREN         => CTRL_WREN,
                     CTRL_DQS_RST      => CTRL_DQS_RST,
                     CTRL_DQS_EN       => CTRL_DQS_EN,
                     CTRL_DUMMY_WR_SEL => CTRL_DUMMY_WR_SEL,
                     dqs_rst           => dqs_rst,
                     dqs_en            => dqs_en,
                     wr_en             => wr_en,
                     wr_data_rise      => wr_data_rise,
                     wr_data_fall      => wr_data_fall,
                     mask_data_rise    => mask_data_rise,
                     mask_data_fall    => mask_data_fall
                 );



  
tap_logic_00 : mem_interface_small_tap_logic_0 
port map (
      CLK                  => CLK,
      CAL_CLK              => CAL_CLK,
      RESET0               => RESET0,
      RESET_CAL_CLK        => RESET_CAL_CLK,
      CTRL_DUMMYREAD_START => CTRL_DUMMYREAD_START,
      idelay_ctrl_rdy      => idelay_ctrl_rdy, 
      dqs_delayed          => dqs_delayed,                
      dqs_idelay_inc       => dqs_idelay_inc,
      dqs_idelay_ce        => dqs_idelay_ce,
      dqs_idelay_rst       => dqs_idelay_rst,
      data_idelay_inc      => data_idelay_inc,
      data_idelay_ce       => data_idelay_ce,
      data_idelay_rst      => data_idelay_rst,
      SEL_DONE             => SEL_DONE
      );
                            
end arc_data_path;
