/*******************************************************************************
 *	BList.h		BEAM List
 *			T.Barnaby,	BEAM Ltd,	4/8/00
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BLIST_H
#define BLIST_H	1

class BNode {
public:
		BNode() : next(0), prev(0){}
	BNode*	next;
	BNode*	prev;
};

/// Iterator for BList 
class BIter {
public:
		BIter(BNode* i = 0)		{	oi = i;			}
		operator BNode* ()		{	return oi;		}
	int	operator==(const BIter& i)	{	return (i.oi == oi);	}
	int	valid()				{	return (oi != 0);	}
private:
	BNode*	oi;
};


/// Template based list class.
template <class T> class BList {
public:
	class Node : public BNode {
	public:
			Node(const T& i) : item(i){}
		T	item;
	};
	typedef int		(*SortFunc)(T& a, T& b);		///< Prototype for sorting function

	// Contructors
		BList();
		BList(const BList<T>& l);
	virtual	~BList();
		
	// Navigation
	void	start(BIter& i) const;				///< Iterator to start of list
	BIter	begin() const;					///< Iterator for start of list
	BIter	end() const;					///< Iterator for end of list
	BIter	end(BIter& i) const;				///< Iterator for end of list
	void	next(BIter& i) const;				///< Iterator for next item in list
	void	prev(BIter& i);					///< Iterator for previous item in list
	BIter	goTo(int pos) const;				///< Iterator for pos item in list 
	int	position(BIter i);				///< Postition in list item with iterator i
	
	// Information
	unsigned int	number() const;				///< Number of items in list
	unsigned int	size() const;					///< Number of items in list
	int	isEnd(BIter& i) const;				///< True if iterator refers to last item
	
	// Get items
	T&	front();					///< Get first item in list
	T&	rear();						///< Get last item in list
	T&	get(BIter i);					///< Get item specified by iterator in list
	const T&	get(BIter i) const;			///< Get item specified by iterator in list
	
	// Insert items
	void	append(const T& item);				///< Append item to list
	virtual void	insert(BIter& i, const T& item);	///< Insert item before item 
	void	insertAfter(BIter& i, const T& item);		///< Insert item after item
	
	// Delete items
	virtual void	clear();				///< Clear the list
	virtual void	del(BIter& i);				///< Delete specified item
	void	deleteLast();					///< Delete last item
	void	deleteFirst();					///< Delete fisrt item

	// Stack
	void	push(const T& i);				///< Push item onto list
	T	pop();						///< Pop item from list deleteing item

	// Queue
	void	queueAdd(const T& i);				///< Add item to end of list
	T	queueGet();					///< Get item from front of list deleteing item

	// Misc
	void	append(const BList<T>& l);			///< Append list to list
	int	has(const T& i) const;				///< Checks if the item is in the list
	void	swap(BIter i1, BIter i2);			///< Swap two items in list
	void	sort();						///< Sort list based on get(i) values
	void	sort(SortFunc func);				///< Sort list based on Sort func
				
	// Operator functions
	BList<T>&	operator=(const BList<T>& l);
	T&	operator[](int i);
	const T&	operator[](int i) const;
	T&	operator[](BIter i);
	const T&	operator[](const BIter& i) const;
	BList<T>	operator+(const BList<T>& l) const;
protected:
	virtual Node*		nodeGet(BIter i);
	virtual const Node*	nodeGet(BIter i) const;
	virtual Node*		nodeCreate(const T& item);
	Node*			onodes;
	unsigned int		olength;
private:
	virtual Node*		nodeCreate();
};

#include <BList_func.h>

// Macros
#define BListLoop(list, i)	for(BIter i = list.begin(); !list.isEnd(i); list.next(i))

#endif
