/*******************************************************************************
 *	BRefData.cc		Referenced data storage
 *				T.Barnaby,	Beam Ltd,	6/10/94
 *******************************************************************************
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <BRefData.h>

#define CHUNK	16

BRefData::BRefData(){
	odata = 0;
	olen = 0;
	orefCount = 1;
}

BRefData::BRefData(int len){
	odata = 0;
	olen = 0;
	orefCount = 1;
	setLen(len);
}

BRefData::BRefData(const BRefData& refData){
	olen = refData.olen;
	odata = malloc(olen);
	memcpy(odata, refData.odata, olen);
	orefCount = 1;
}

BRefData& BRefData::operator=(const BRefData& refData){
	free(odata);
	olen = refData.olen;
	odata = malloc(olen);
	memcpy(odata, refData.odata, olen);
	orefCount = 1;
	return *this;
}

BRefData::~BRefData(){
	free(odata);
	odata = 0;
	olen = 0;
	orefCount = 0;
}

BRefData* BRefData::copy(){
	BRefData*	r = this;

	if(++orefCount > 2){
		r = new BRefData(*this);
		orefCount.add(-2);
	}
	else {
		orefCount--;
	}
	return r;
}

BRefData* BRefData::addRef(){
	orefCount++;
	return this;
}

int BRefData::deleteRef(){
	return --orefCount;
}

void BRefData::setLen(int len){
	olen = len;
	odata = realloc(odata, olen);
}
