/*******************************************************************************
 *	Da8150.h	Da8150 output classes
 *			T.Barnaby,	BEAM Ltd,	2007-01-23
 *******************************************************************************
 */

#ifndef Da8150_h
#define Da8150_h	1

#include <BList.h>
#include <SigGen.h>
#include <stdint.h>

class Da8150 {
public:
			Da8150();
			~Da8150();
	
	BError		config(double sampleRate, int numChannels);
	void		close();

	BError		output(BSignal& sig);
	BError		output(BSignalList& sigs);

protected:
	BError		expand(BSignalList& sigs, BSignalList& newSigs);
	BError		rawOutput(BSignalList& sigs);
	
	double		osampleRate;
	int		onumChannels;
	int		ocardNum;
};

#endif
